@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of certificate imported from key vault.
 * @property activateDate The activate date of certificate.
 * @property dnsNames The domain list of certificate.
 * @property expirationDate The expiration date of certificate.
 * @property issuedDate The issue date of certificate.
 * @property issuer The issuer of certificate.
 * @property provisioningState Provisioning state of the Certificate
 * @property subjectName The subject name of certificate.
 * @property thumbprint The thumbprint of certificate.
 * @property type The type of the certificate source.
 * Expected value is 'ContentCertificate'.
 */
public data class ContentCertificatePropertiesResponse(
    public val activateDate: String,
    public val dnsNames: List<String>,
    public val expirationDate: String,
    public val issuedDate: String,
    public val issuer: String,
    public val provisioningState: String,
    public val subjectName: String,
    public val thumbprint: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ContentCertificatePropertiesResponse): ContentCertificatePropertiesResponse = ContentCertificatePropertiesResponse(
            activateDate = javaType.activateDate(),
            dnsNames = javaType.dnsNames().map({ args0 -> args0 }),
            expirationDate = javaType.expirationDate(),
            issuedDate = javaType.issuedDate(),
            issuer = javaType.issuer(),
            provisioningState = javaType.provisioningState(),
            subjectName = javaType.subjectName(),
            thumbprint = javaType.thumbprint(),
            type = javaType.type(),
        )
    }
}
