@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Custom container payload
 * @property args Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
 * @property command Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
 * @property containerImage Container image of the custom container. This should be in the form of <repository>:<tag> without the server name of the registry
 * @property imageRegistryCredential Credential of the image registry
 * @property languageFramework Language framework of the container image uploaded. Supported values: "springboot", "", null.
 * @property server The name of the registry that contains the container image
 */
public data class CustomContainerResponse(
    public val args: List<String>? = null,
    public val command: List<String>? = null,
    public val containerImage: String? = null,
    public val imageRegistryCredential: ImageRegistryCredentialResponse? = null,
    public val languageFramework: String? = null,
    public val server: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.CustomContainerResponse): CustomContainerResponse = CustomContainerResponse(
            args = javaType.args().map({ args0 -> args0 }),
            command = javaType.command().map({ args0 -> args0 }),
            containerImage = javaType.containerImage().map({ args0 -> args0 }).orElse(null),
            imageRegistryCredential = javaType.imageRegistryCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ImageRegistryCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            languageFramework = javaType.languageFramework().map({ args0 -> args0 }).orElse(null),
            server = javaType.server().map({ args0 -> args0 }).orElse(null),
        )
    }
}
