@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Custom domain of app resource payload.
 * @property appName The app name of domain.
 * @property certName The bound certificate name of domain.
 * @property provisioningState Provisioning state of the Domain
 * @property thumbprint The thumbprint of bound certificate.
 */
public data class CustomDomainPropertiesResponse(
    public val appName: String,
    public val certName: String? = null,
    public val provisioningState: String,
    public val thumbprint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.CustomDomainPropertiesResponse): CustomDomainPropertiesResponse = CustomDomainPropertiesResponse(
            appName = javaType.appName(),
            certName = javaType.certName().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            thumbprint = javaType.thumbprint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
