@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Customized accelerator properties payload
 * @property acceleratorTags
 * @property description
 * @property displayName
 * @property gitRepository
 * @property iconUrl
 * @property provisioningState State of the customized accelerator.
 */
public data class CustomizedAcceleratorPropertiesResponse(
    public val acceleratorTags: List<String>? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val gitRepository: AcceleratorGitRepositoryResponse,
    public val iconUrl: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.CustomizedAcceleratorPropertiesResponse): CustomizedAcceleratorPropertiesResponse = CustomizedAcceleratorPropertiesResponse(
            acceleratorTags = javaType.acceleratorTags().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            gitRepository = javaType.gitRepository().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.AcceleratorGitRepositoryResponse.Companion.toKotlin(args0)
            }),
            iconUrl = javaType.iconUrl().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
