@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Deployment instance payload
 * @property discoveryStatus Discovery status of the deployment instance
 * @property name Name of the deployment instance
 * @property reason Failed reason of the deployment instance
 * @property startTime Start time of the deployment instance
 * @property status Status of the deployment instance
 * @property zone Availability zone information of the deployment instance
 */
public data class DeploymentInstanceResponse(
    public val discoveryStatus: String,
    public val name: String,
    public val reason: String,
    public val startTime: String,
    public val status: String,
    public val zone: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.DeploymentInstanceResponse): DeploymentInstanceResponse = DeploymentInstanceResponse(
            discoveryStatus = javaType.discoveryStatus(),
            name = javaType.name(),
            reason = javaType.reason(),
            startTime = javaType.startTime(),
            status = javaType.status(),
            zone = javaType.zone(),
        )
    }
}
