@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Detail settings for Dev Tool Portal feature
 * @property route Route path to visit the plugin
 * @property state State of the plugin
 */
public data class DevToolPortalFeatureDetailResponse(
    public val route: String,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.DevToolPortalFeatureDetailResponse): DevToolPortalFeatureDetailResponse = DevToolPortalFeatureDetailResponse(
            route = javaType.route(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
