@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Suppress

/**
 * Settings for Dev Tool Portal
 * @property applicationAccelerator Detail of Accelerator plugin
 * @property applicationLiveView Detail of App Live View plugin
 */
public data class DevToolPortalFeatureSettingsResponse(
    public val applicationAccelerator: DevToolPortalFeatureDetailResponse? = null,
    public val applicationLiveView: DevToolPortalFeatureDetailResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.DevToolPortalFeatureSettingsResponse): DevToolPortalFeatureSettingsResponse = DevToolPortalFeatureSettingsResponse(
            applicationAccelerator = javaType.applicationAccelerator().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.DevToolPortalFeatureDetailResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            applicationLiveView = javaType.applicationLiveView().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.DevToolPortalFeatureDetailResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
