@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Spring Apps components' environment variable.
 * @property name Environment variable name.
 * @property secretValue secret environment variable value.
 * @property value Non-secret environment variable value.
 */
public data class EnvVarResponse(
    public val name: String? = null,
    public val secretValue: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.EnvVarResponse): EnvVarResponse = EnvVarResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            secretValue = javaType.secretValue().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
