@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * API route config of the Spring Cloud Gateway
 * @property description A description, will be applied to methods in the generated OpenAPI documentation.
 * @property filters To modify the request before sending it to the target endpoint, or the received response.
 * @property order Route processing order.
 * @property predicates A number of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
 * @property ssoEnabled Enable sso validation.
 * @property tags Classification tags, will be applied to methods in the generated OpenAPI documentation.
 * @property title A title, will be applied to methods in the generated OpenAPI documentation.
 * @property tokenRelay Pass currently-authenticated user's identity token to application service, default is 'false'
 * @property uri Full uri, will override `appName`.
 */
public data class GatewayApiRouteResponse(
    public val description: String? = null,
    public val filters: List<String>? = null,
    public val order: Int? = null,
    public val predicates: List<String>? = null,
    public val ssoEnabled: Boolean? = null,
    public val tags: List<String>? = null,
    public val title: String? = null,
    public val tokenRelay: Boolean? = null,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GatewayApiRouteResponse): GatewayApiRouteResponse = GatewayApiRouteResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            filters = javaType.filters().map({ args0 -> args0 }),
            order = javaType.order().map({ args0 -> args0 }).orElse(null),
            predicates = javaType.predicates().map({ args0 -> args0 }),
            ssoEnabled = javaType.ssoEnabled().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0 }),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            tokenRelay = javaType.tokenRelay().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
