@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Collection of instances belong to the Spring Cloud Gateway
 * @property name Name of the Spring Cloud Gateway instance
 * @property status Status of the Spring Cloud Gateway instance
 */
public data class GatewayInstanceResponse(
    public val name: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GatewayInstanceResponse): GatewayInstanceResponse = GatewayInstanceResponse(
            name = javaType.name(),
            status = javaType.status(),
        )
    }
}
