@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of the Spring Cloud Gateway Operator.
 * @property instances Collection of instances belong to Spring Cloud Gateway operator.
 * @property resourceRequests The requested resource quantity for required CPU and Memory.
 */
public data class GatewayOperatorPropertiesResponse(
    public val instances: List<GatewayInstanceResponse>,
    public val resourceRequests: GatewayOperatorResourceRequestsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GatewayOperatorPropertiesResponse): GatewayOperatorPropertiesResponse = GatewayOperatorPropertiesResponse(
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayInstanceResponse.Companion.toKotlin(args0)
                })
            }),
            resourceRequests = javaType.resourceRequests().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayOperatorResourceRequestsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
