@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Spring Cloud Gateway properties payload
 * @property addonConfigs Collection of addons for Spring Cloud Gateway
 * @property apiMetadataProperties API metadata property for Spring Cloud Gateway
 * @property apmTypes Collection of APM type used in Spring Cloud Gateway
 * @property clientAuth Client-Certification Authentication.
 * @property corsProperties Cross-Origin Resource Sharing property
 * @property environmentVariables Environment variables of Spring Cloud Gateway
 * @property httpsOnly Indicate if only https is allowed.
 * @property instances Collection of instances belong to Spring Cloud Gateway.
 * @property operatorProperties Properties of the Spring Cloud Gateway Operator.
 * @property provisioningState State of the Spring Cloud Gateway.
 * @property public Indicates whether the Spring Cloud Gateway exposes endpoint.
 * @property resourceRequests The requested resource quantity for required CPU and Memory.
 * @property ssoProperties Single sign-on related configuration
 * @property url URL of the Spring Cloud Gateway, exposed when 'public' is true.
 */
public data class GatewayPropertiesResponse(
    public val addonConfigs: Map<String, Any>? = null,
    public val apiMetadataProperties: GatewayApiMetadataPropertiesResponse? = null,
    public val apmTypes: List<String>? = null,
    public val clientAuth: GatewayPropertiesResponseClientAuth? = null,
    public val corsProperties: GatewayCorsPropertiesResponse? = null,
    public val environmentVariables: GatewayPropertiesResponseEnvironmentVariables? = null,
    public val httpsOnly: Boolean? = null,
    public val instances: List<GatewayInstanceResponse>,
    public val operatorProperties: GatewayOperatorPropertiesResponse,
    public val provisioningState: String,
    public val `public`: Boolean? = null,
    public val resourceRequests: GatewayResourceRequestsResponse? = null,
    public val ssoProperties: SsoPropertiesResponse? = null,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GatewayPropertiesResponse): GatewayPropertiesResponse = GatewayPropertiesResponse(
            addonConfigs = javaType.addonConfigs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            apiMetadataProperties = javaType.apiMetadataProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayApiMetadataPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            apmTypes = javaType.apmTypes().map({ args0 -> args0 }),
            clientAuth = javaType.clientAuth().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayPropertiesResponseClientAuth.Companion.toKotlin(args0)
                })
            }).orElse(null),
            corsProperties = javaType.corsProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayCorsPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayPropertiesResponseEnvironmentVariables.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpsOnly = javaType.httpsOnly().map({ args0 -> args0 }).orElse(null),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayInstanceResponse.Companion.toKotlin(args0)
                })
            }),
            operatorProperties = javaType.operatorProperties().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayOperatorPropertiesResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            `public` = javaType.public_().map({ args0 -> args0 }).orElse(null),
            resourceRequests = javaType.resourceRequests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayResourceRequestsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ssoProperties = javaType.ssoProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.SsoPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            url = javaType.url(),
        )
    }
}
