@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * API route config of the Spring Cloud Gateway
 * @property appResourceId The resource Id of the Azure Spring Apps app, required unless route defines `uri`.
 * @property filters To modify the request before sending it to the target endpoint, or the received response in app level.
 * @property openApi OpenAPI properties of Spring Cloud Gateway route config.
 * @property predicates A number of conditions to evaluate a route for each request in app level. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
 * @property protocol Protocol of routed Azure Spring Apps applications.
 * @property provisioningState State of the Spring Cloud Gateway route config.
 * @property routes Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`.
 * @property ssoEnabled Enable Single Sign-On in app level.
 */
public data class GatewayRouteConfigPropertiesResponse(
    public val appResourceId: String? = null,
    public val filters: List<String>? = null,
    public val openApi: GatewayRouteConfigOpenApiPropertiesResponse? = null,
    public val predicates: List<String>? = null,
    public val protocol: String? = null,
    public val provisioningState: String,
    public val routes: List<GatewayApiRouteResponse>? = null,
    public val ssoEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GatewayRouteConfigPropertiesResponse): GatewayRouteConfigPropertiesResponse = GatewayRouteConfigPropertiesResponse(
            appResourceId = javaType.appResourceId().map({ args0 -> args0 }).orElse(null),
            filters = javaType.filters().map({ args0 -> args0 }),
            openApi = javaType.openApi().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayRouteConfigOpenApiPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            predicates = javaType.predicates().map({ args0 -> args0 }),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayApiRouteResponse.Companion.toKotlin(args0)
                })
            }),
            ssoEnabled = javaType.ssoEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
