@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Custom domain of the API portal
 * @property id Fully qualified resource Id for the resource.
 * @property name The name of the resource.
 * @property properties The properties of custom domain for API portal
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 */
public data class GetApiPortalCustomDomainResult(
    public val id: String,
    public val name: String,
    public val properties: ApiPortalCustomDomainPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GetApiPortalCustomDomainResult): GetApiPortalCustomDomainResult = GetApiPortalCustomDomainResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.ApiPortalCustomDomainPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
