@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource upload definition payload
 * @property relativePath Source relative path
 * @property uploadUrl Upload URL
 */
public data class GetAppResourceUploadUrlResult(
    public val relativePath: String? = null,
    public val uploadUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GetAppResourceUploadUrlResult): GetAppResourceUploadUrlResult = GetAppResourceUploadUrlResult(
            relativePath = javaType.relativePath().map({ args0 -> args0 }).orElse(null),
            uploadUrl = javaType.uploadUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
