@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Certificate resource payload.
 * @property id Fully qualified resource Id for the resource.
 * @property name The name of the resource.
 * @property properties Properties of the certificate resource payload.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 */
public data class GetCertificateResult(
    public val id: String,
    public val name: String,
    public val properties: Either<ContentCertificatePropertiesResponse, KeyVaultCertificatePropertiesResponse>,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GetCertificateResult): GetCertificateResult = GetCertificateResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.appplatform.kotlin.outputs.ContentCertificatePropertiesResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.appplatform.kotlin.outputs.KeyVaultCertificatePropertiesResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
