@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Service resource
 * @property id Fully qualified resource Id for the resource.
 * @property location The GEO location of the resource.
 * @property name The name of the resource.
 * @property properties Properties of the Service resource
 * @property sku Sku of the Service resource
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Tags of the service which is a list of key value pairs that describe the resource.
 * @property type The type of the resource.
 */
public data class GetServiceResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: ClusterResourcePropertiesResponse,
    public val sku: SkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GetServiceResult): GetServiceResult = GetServiceResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.ClusterResourcePropertiesResponse.Companion.toKotlin(args0)
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
