@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Git repository property payload for config server
 * @property hostKey Public sshKey of git repository.
 * @property hostKeyAlgorithm SshKey algorithm of git repository.
 * @property label Label of the repository
 * @property name Name of the repository
 * @property password Password of git repository basic auth.
 * @property pattern Collection of pattern of the repository
 * @property privateKey Private sshKey algorithm of git repository.
 * @property searchPaths Searching path of the repository
 * @property strictHostKeyChecking Strict host key checking or not.
 * @property uri URI of the repository
 * @property username Username of git repository basic auth.
 */
public data class GitPatternRepositoryResponse(
    public val hostKey: String? = null,
    public val hostKeyAlgorithm: String? = null,
    public val label: String? = null,
    public val name: String,
    public val password: String? = null,
    public val pattern: List<String>? = null,
    public val privateKey: String? = null,
    public val searchPaths: List<String>? = null,
    public val strictHostKeyChecking: Boolean? = null,
    public val uri: String,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GitPatternRepositoryResponse): GitPatternRepositoryResponse = GitPatternRepositoryResponse(
            hostKey = javaType.hostKey().map({ args0 -> args0 }).orElse(null),
            hostKeyAlgorithm = javaType.hostKeyAlgorithm().map({ args0 -> args0 }).orElse(null),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            pattern = javaType.pattern().map({ args0 -> args0 }),
            privateKey = javaType.privateKey().map({ args0 -> args0 }).orElse(null),
            searchPaths = javaType.searchPaths().map({ args0 -> args0 }),
            strictHostKeyChecking = javaType.strictHostKeyChecking().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri(),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
