@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Credential of the image registry
 * @property password The password of the image registry credential
 * @property username The username of the image registry credential
 */
public data class ImageRegistryCredentialResponse(
    public val password: String? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ImageRegistryCredentialResponse): ImageRegistryCredentialResponse = ImageRegistryCredentialResponse(
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
