@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Uploaded Jar binary for a deployment
 * @property jvmOptions JVM parameter
 * @property relativePath Relative path of the storage which stores the source
 * @property runtimeVersion Runtime version of the Jar file
 * @property type Type of the source uploaded
 * Expected value is 'Jar'.
 * @property version Version of the source
 */
public data class JarUploadedUserSourceInfoResponse(
    public val jvmOptions: String? = null,
    public val relativePath: String? = null,
    public val runtimeVersion: String? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.JarUploadedUserSourceInfoResponse): JarUploadedUserSourceInfoResponse = JarUploadedUserSourceInfoResponse(
            jvmOptions = javaType.jvmOptions().map({ args0 -> args0 }).orElse(null),
            relativePath = javaType.relativePath().map({ args0 -> args0 }).orElse(null),
            runtimeVersion = javaType.runtimeVersion().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
