@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Job's execution template, containing configuration for an execution
 * @property args Arguments for the Job execution.
 * @property environmentVariables Environment variables of Job execution
 * @property resourceRequests The requested resource quantity for required CPU and Memory.
 */
public data class JobExecutionTemplateResponse(
    public val args: List<String>? = null,
    public val environmentVariables: List<EnvVarResponse>? = null,
    public val resourceRequests: JobResourceRequestsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.JobExecutionTemplateResponse): JobExecutionTemplateResponse = JobExecutionTemplateResponse(
            args = javaType.args().map({ args0 -> args0 }),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.EnvVarResponse.Companion.toKotlin(args0)
                })
            }),
            resourceRequests = javaType.resourceRequests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.JobResourceRequestsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
