@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Job resource properties payload
 * @property managedComponentReferences Referenced managed components collection
 * @property provisioningState Provisioning state of the Job
 * @property source Uploaded source information of the Job.
 * @property template The template which is applied for all executions of the Job.
 * @property triggerConfig The Job trigger related configuration.
 */
public data class JobResourcePropertiesResponse(
    public val managedComponentReferences: List<ManagedComponentReferenceResponse>? = null,
    public val provisioningState: String,
    public val source: Any? = null,
    public val template: JobExecutionTemplateResponse? = null,
    public val triggerConfig: ManualJobTriggerConfigResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.JobResourcePropertiesResponse): JobResourcePropertiesResponse = JobResourcePropertiesResponse(
            managedComponentReferences = javaType.managedComponentReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ManagedComponentReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            template = javaType.template().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.JobExecutionTemplateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            triggerConfig = javaType.triggerConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ManualJobTriggerConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
