@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Job resource request payload
 * @property cpu CPU allocated to each job execution instance.
 * @property memory Memory allocated to each job execution instance.
 */
public data class JobResourceRequestsResponse(
    public val cpu: String? = null,
    public val memory: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.JobResourceRequestsResponse): JobResourceRequestsResponse = JobResourceRequestsResponse(
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
