@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Loaded certificate payload
 * @property loadTrustStore Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
 * @property resourceId Resource Id of loaded certificate
 */
public data class LoadedCertificateResponse(
    public val loadTrustStore: Boolean? = null,
    public val resourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.LoadedCertificateResponse): LoadedCertificateResponse = LoadedCertificateResponse(
            loadTrustStore = javaType.loadTrustStore().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId(),
        )
    }
}
