@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A reference to the managed component like Config Server.
 * @property resourceId Resource Id of the managed component
 */
public data class ManagedComponentReferenceResponse(
    public val resourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ManagedComponentReferenceResponse): ManagedComponentReferenceResponse = ManagedComponentReferenceResponse(
            resourceId = javaType.resourceId(),
        )
    }
}
