@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Configuration for manual triggered job
 * @property parallelism Number of parallel replicas of a job execution can run.
 * @property retryLimit Maximum number of retries before failing the job.
 * @property timeoutInSeconds Maximum number of seconds an execution is allowed to run.
 * @property triggerType Type of job trigger
 * Expected value is 'Manual'.
 */
public data class ManualJobTriggerConfigResponse(
    public val parallelism: Int? = null,
    public val retryLimit: Int? = null,
    public val timeoutInSeconds: Int? = null,
    public val triggerType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ManualJobTriggerConfigResponse): ManualJobTriggerConfigResponse = ManualJobTriggerConfigResponse(
            parallelism = javaType.parallelism().map({ args0 -> args0 }).orElse(null),
            retryLimit = javaType.retryLimit().map({ args0 -> args0 }).orElse(null),
            timeoutInSeconds = javaType.timeoutInSeconds().map({ args0 -> args0 }).orElse(null),
            triggerType = javaType.triggerType(),
        )
    }
}
