@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Purchasing 3rd Party product for one Azure Spring Apps instance
 * @property plan The plan id of the 3rd Party Artifact that is being procured.
 * @property product The 3rd Party artifact that is being procured.
 * @property publisher The publisher id of the 3rd Party Artifact that is being bought.
 */
public data class MarketplaceResourceResponse(
    public val plan: String? = null,
    public val product: String? = null,
    public val publisher: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.MarketplaceResourceResponse): MarketplaceResourceResponse = MarketplaceResourceResponse(
            plan = javaType.plan().map({ args0 -> args0 }).orElse(null),
            product = javaType.product().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
        )
    }
}
