@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Monitoring Setting properties payload
 * @property appInsightsAgentVersions Indicates the versions of application insight agent
 * @property appInsightsInstrumentationKey Target application insight instrumentation key, null or whitespace include empty will disable monitoringSettings
 * @property appInsightsSamplingRate Indicates the sampling rate of application insight agent, should be in range [0&#46;0, 100&#46;0]
 * @property error Error when apply Monitoring Setting changes.
 * @property provisioningState State of the Monitoring Setting.
 * @property traceEnabled Indicates whether enable the trace functionality, which will be deprecated since api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey to indicate if monitoringSettings enabled or not
 */
public data class MonitoringSettingPropertiesResponse(
    public val appInsightsAgentVersions: ApplicationInsightsAgentVersionsResponse? = null,
    public val appInsightsInstrumentationKey: String? = null,
    public val appInsightsSamplingRate: Double? = null,
    public val error: ErrorResponse? = null,
    public val provisioningState: String,
    public val traceEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.MonitoringSettingPropertiesResponse): MonitoringSettingPropertiesResponse = MonitoringSettingPropertiesResponse(
            appInsightsAgentVersions = javaType.appInsightsAgentVersions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ApplicationInsightsAgentVersionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            appInsightsInstrumentationKey = javaType.appInsightsInstrumentationKey().map({ args0 ->
                args0
            }).orElse(null),
            appInsightsSamplingRate = javaType.appInsightsSamplingRate().map({ args0 -> args0 }).orElse(null),
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            traceEnabled = javaType.traceEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
