@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Uploaded Jar binary for a deployment
 * @property netCoreMainEntryPath The path to the .NET executable relative to zip root
 * @property relativePath Relative path of the storage which stores the source
 * @property runtimeVersion Runtime version of the .Net file
 * @property type Type of the source uploaded
 * Expected value is 'NetCoreZip'.
 * @property version Version of the source
 */
public data class NetCoreZipUploadedUserSourceInfoResponse(
    public val netCoreMainEntryPath: String? = null,
    public val relativePath: String? = null,
    public val runtimeVersion: String? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.NetCoreZipUploadedUserSourceInfoResponse): NetCoreZipUploadedUserSourceInfoResponse = NetCoreZipUploadedUserSourceInfoResponse(
            netCoreMainEntryPath = javaType.netCoreMainEntryPath().map({ args0 -> args0 }).orElse(null),
            relativePath = javaType.relativePath().map({ args0 -> args0 }).orElse(null),
            runtimeVersion = javaType.runtimeVersion().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
