@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Service network profile payload
 * @property appNetworkResourceGroup Name of the resource group containing network resources for customer apps in Azure Spring Apps
 * @property appSubnetId Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps
 * @property ingressConfig Ingress configuration payload for Azure Spring Apps resource.
 * @property outboundIPs Desired outbound IP resources for Azure Spring Apps resource.
 * @property outboundType The egress traffic type of Azure Spring Apps VNet instances.
 * @property requiredTraffics Required inbound or outbound traffics for Azure Spring Apps resource.
 * @property serviceCidr Azure Spring Apps service reserved CIDR
 * @property serviceRuntimeNetworkResourceGroup Name of the resource group containing network resources of Azure Spring Apps Service Runtime
 * @property serviceRuntimeSubnetId Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime
 */
public data class NetworkProfileResponse(
    public val appNetworkResourceGroup: String? = null,
    public val appSubnetId: String? = null,
    public val ingressConfig: IngressConfigResponse? = null,
    public val outboundIPs: NetworkProfileResponseOutboundIPs,
    public val outboundType: String? = null,
    public val requiredTraffics: List<RequiredTrafficResponse>,
    public val serviceCidr: String? = null,
    public val serviceRuntimeNetworkResourceGroup: String? = null,
    public val serviceRuntimeSubnetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.NetworkProfileResponse): NetworkProfileResponse = NetworkProfileResponse(
            appNetworkResourceGroup = javaType.appNetworkResourceGroup().map({ args0 -> args0 }).orElse(null),
            appSubnetId = javaType.appSubnetId().map({ args0 -> args0 }).orElse(null),
            ingressConfig = javaType.ingressConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.IngressConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            outboundIPs = javaType.outboundIPs().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.NetworkProfileResponseOutboundIPs.Companion.toKotlin(args0)
            }),
            outboundType = javaType.outboundType().map({ args0 -> args0 }).orElse(null),
            requiredTraffics = javaType.requiredTraffics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.RequiredTrafficResponse.Companion.toKotlin(args0)
                })
            }),
            serviceCidr = javaType.serviceCidr().map({ args0 -> args0 }).orElse(null),
            serviceRuntimeNetworkResourceGroup = javaType.serviceRuntimeNetworkResourceGroup().map({ args0 ->
                args0
            }).orElse(null),
            serviceRuntimeSubnetId = javaType.serviceRuntimeSubnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
