@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Desired outbound IP resources for Azure Spring Apps resource.
 * @property publicIPs A list of public IP addresses.
 */
public data class NetworkProfileResponseOutboundIPs(
    public val publicIPs: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.NetworkProfileResponseOutboundIPs): NetworkProfileResponseOutboundIPs = NetworkProfileResponseOutboundIPs(
            publicIPs = javaType.publicIPs().map({ args0 -> args0 }),
        )
    }
}
