@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Persistent disk payload
 * @property mountPath Mount path of the persistent disk
 * @property sizeInGB Size of the persistent disk in GB
 * @property usedInGB Size of the used persistent disk in GB
 */
public data class PersistentDiskResponse(
    public val mountPath: String? = null,
    public val sizeInGB: Int? = null,
    public val usedInGB: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.PersistentDiskResponse): PersistentDiskResponse = PersistentDiskResponse(
            mountPath = javaType.mountPath().map({ args0 -> args0 }).orElse(null),
            sizeInGB = javaType.sizeInGB().map({ args0 -> args0 }).orElse(null),
            usedInGB = javaType.usedInGB(),
        )
    }
}
