@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Required inbound or outbound traffic for Azure Spring Apps resource.
 * @property direction The direction of required traffic
 * @property fqdns The FQDN list of required traffic
 * @property ips The ip list of required traffic
 * @property port The port of required traffic
 * @property protocol The protocol of required traffic
 */
public data class RequiredTrafficResponse(
    public val direction: String,
    public val fqdns: List<String>,
    public val ips: List<String>,
    public val port: Int,
    public val protocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.RequiredTrafficResponse): RequiredTrafficResponse = RequiredTrafficResponse(
            direction = javaType.direction(),
            fqdns = javaType.fqdns().map({ args0 -> args0 }),
            ips = javaType.ips().map({ args0 -> args0 }),
            port = javaType.port(),
            protocol = javaType.protocol(),
        )
    }
}
