@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure Spring Apps scaling configurations.
 * @property maxReplicas Optional. Maximum number of container replicas. Defaults to 10 if not set.
 * @property minReplicas Optional. Minimum number of container replicas.
 * @property rules Scaling rules.
 */
public data class ScaleResponse(
    public val maxReplicas: Int? = null,
    public val minReplicas: Int? = null,
    public val rules: List<ScaleRuleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ScaleResponse): ScaleResponse = ScaleResponse(
            maxReplicas = javaType.maxReplicas().map({ args0 -> args0 }).orElse(null),
            minReplicas = javaType.minReplicas().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ScaleRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
