@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Spring Apps App Instance scaling rule.
 * @property azureQueue Azure Queue based scaling.
 * @property custom Custom scale rule.
 * @property http HTTP requests based scaling.
 * @property name Scale Rule Name
 * @property tcp Tcp requests based scaling.
 */
public data class ScaleRuleResponse(
    public val azureQueue: QueueScaleRuleResponse? = null,
    public val custom: CustomScaleRuleResponse? = null,
    public val http: HttpScaleRuleResponse? = null,
    public val name: String? = null,
    public val tcp: TcpScaleRuleResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ScaleRuleResponse): ScaleRuleResponse = ScaleRuleResponse(
            azureQueue = javaType.azureQueue().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.QueueScaleRuleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            custom = javaType.custom().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.CustomScaleRuleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            http = javaType.http().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.HttpScaleRuleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tcp = javaType.tcp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.TcpScaleRuleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
