@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Collection of instances belong to the Service Registry
 * @property name Name of the Service Registry instance
 * @property status Status of the Service Registry instance
 */
public data class ServiceRegistryInstanceResponse(
    public val name: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ServiceRegistryInstanceResponse): ServiceRegistryInstanceResponse = ServiceRegistryInstanceResponse(
            name = javaType.name(),
            status = javaType.status(),
        )
    }
}
