@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Resource request payload of Service Registry
 * @property cpu Cpu allocated to each Service Registry instance
 * @property instanceCount Instance count of the Service Registry
 * @property memory Memory allocated to each Service Registry instance
 */
public data class ServiceRegistryResourceRequestsResponse(
    public val cpu: String,
    public val instanceCount: Int,
    public val memory: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ServiceRegistryResourceRequestsResponse): ServiceRegistryResourceRequestsResponse = ServiceRegistryResourceRequestsResponse(
            cpu = javaType.cpu(),
            instanceCount = javaType.instanceCount(),
            memory = javaType.memory(),
        )
    }
}
