@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Uploaded Java source code binary for a deployment
 * @property artifactSelector Selector for the artifact to be used for the deployment for multi-module projects. This should be
 * the relative path to the target module/project.
 * @property relativePath Relative path of the storage which stores the source
 * @property runtimeVersion Runtime version of the source file
 * @property type Type of the source uploaded
 * Expected value is 'Source'.
 * @property version Version of the source
 */
public data class SourceUploadedUserSourceInfoResponse(
    public val artifactSelector: String? = null,
    public val relativePath: String? = null,
    public val runtimeVersion: String? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.SourceUploadedUserSourceInfoResponse): SourceUploadedUserSourceInfoResponse = SourceUploadedUserSourceInfoResponse(
            artifactSelector = javaType.artifactSelector().map({ args0 -> args0 }).orElse(null),
            relativePath = javaType.relativePath().map({ args0 -> args0 }).orElse(null),
            runtimeVersion = javaType.runtimeVersion().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
