@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Single sign-on related configuration
 * @property clientId The public identifier for the application
 * @property clientSecret The secret known only to the application and the authorization server
 * @property issuerUri The URI of Issuer Identifier
 * @property scope It defines the specific actions applications can be allowed to do on a user's behalf
 */
public data class SsoPropertiesResponse(
    public val clientId: String? = null,
    public val clientSecret: String? = null,
    public val issuerUri: String? = null,
    public val scope: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.SsoPropertiesResponse): SsoPropertiesResponse = SsoPropertiesResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
            issuerUri = javaType.issuerUri().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }),
        )
    }
}
