@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * storage resource of type Azure Storage Account.
 * @property accountName The account name of the Azure Storage Account.
 * @property storageType The type of the storage.
 * Expected value is 'StorageAccount'.
 */
public data class StorageAccountResponse(
    public val accountName: String,
    public val storageType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.StorageAccountResponse): StorageAccountResponse = StorageAccountResponse(
            accountName = javaType.accountName(),
            storageType = javaType.storageType(),
        )
    }
}
