@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * TCPSocketAction describes an action based on opening a socket
 * @property type The type of the action to take to perform the health check.
 * Expected value is 'TCPSocketAction'.
 */
public data class TCPSocketActionResponse(
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.TCPSocketActionResponse): TCPSocketActionResponse = TCPSocketActionResponse(
            type = javaType.type(),
        )
    }
}
