@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Source with uploaded location
 * @property relativePath Relative path of the storage which stores the source
 * @property type Type of the source uploaded
 * Expected value is 'UploadedUserSourceInfo'.
 * @property version Version of the source
 */
public data class UploadedUserSourceInfoResponse(
    public val relativePath: String? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.UploadedUserSourceInfoResponse): UploadedUserSourceInfoResponse = UploadedUserSourceInfoResponse(
            relativePath = javaType.relativePath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
