@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.attestation.kotlin

import com.pulumi.azurenative.attestation.AttestationFunctions.getAttestationProviderPlain
import com.pulumi.azurenative.attestation.AttestationFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.attestation.kotlin.inputs.GetAttestationProviderPlainArgs
import com.pulumi.azurenative.attestation.kotlin.inputs.GetAttestationProviderPlainArgsBuilder
import com.pulumi.azurenative.attestation.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.attestation.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.attestation.kotlin.outputs.GetAttestationProviderResult
import com.pulumi.azurenative.attestation.kotlin.outputs.GetPrivateEndpointConnectionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.attestation.kotlin.outputs.GetAttestationProviderResult.Companion.toKotlin as getAttestationProviderResultToKotlin
import com.pulumi.azurenative.attestation.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin

public object AttestationFunctions {
    /**
     * Get the status of Attestation Provider.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return Attestation service response message.
     */
    public suspend fun getAttestationProvider(argument: GetAttestationProviderPlainArgs): GetAttestationProviderResult =
        getAttestationProviderResultToKotlin(getAttestationProviderPlain(argument.toJava()).await())

    /**
     * @see [getAttestationProvider].
     * @param providerName Name of the attestation provider.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Attestation service response message.
     */
    public suspend fun getAttestationProvider(providerName: String, resourceGroupName: String): GetAttestationProviderResult {
        val argument = GetAttestationProviderPlainArgs(
            providerName = providerName,
            resourceGroupName = resourceGroupName,
        )
        return getAttestationProviderResultToKotlin(getAttestationProviderPlain(argument.toJava()).await())
    }

    /**
     * @see [getAttestationProvider].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;attestation&#46;kotlin&#46;inputs&#46;GetAttestationProviderPlainArgs].
     * @return Attestation service response message.
     */
    public suspend fun getAttestationProvider(argument: suspend GetAttestationProviderPlainArgsBuilder.() -> Unit): GetAttestationProviderResult {
        val builder = GetAttestationProviderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAttestationProviderResultToKotlin(getAttestationProviderPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the attestation provider.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param providerName The name of the attestation provider.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        providerName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            providerName = providerName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;attestation&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }
}
