@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.attestation.kotlin

import com.pulumi.azurenative.attestation.AttestationProviderArgs.builder
import com.pulumi.azurenative.attestation.kotlin.inputs.AttestationServiceCreationSpecificParamsArgs
import com.pulumi.azurenative.attestation.kotlin.inputs.AttestationServiceCreationSpecificParamsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Attestation service response message.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### AttestationProviders_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attestationProvider = new AzureNative.Attestation.AttestationProvider("attestationProvider", new()
 *     {
 *         Location = "East US",
 *         Properties = new AzureNative.Attestation.Inputs.AttestationServiceCreationSpecificParamsArgs
 *         {
 *             PublicNetworkAccess = AzureNative.Attestation.PublicNetworkAccessType.Enabled,
 *             TpmAttestationAuthentication = AzureNative.Attestation.TpmAttestationAuthenticationType.Enabled,
 *         },
 *         ProviderName = "myattestationprovider",
 *         ResourceGroupName = "MyResourceGroup",
 *         Tags =
 *         {
 *             { "Property1", "Value1" },
 *             { "Property2", "Value2" },
 *             { "Property3", "Value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/attestation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := attestation.NewAttestationProvider(ctx, "attestationProvider", &attestation.AttestationProviderArgs{
 * 			Location: pulumi.String("East US"),
 * 			Properties: &attestation.AttestationServiceCreationSpecificParamsArgs{
 * 				PublicNetworkAccess:          pulumi.String(attestation.PublicNetworkAccessTypeEnabled),
 * 				TpmAttestationAuthentication: pulumi.String(attestation.TpmAttestationAuthenticationTypeEnabled),
 * 			},
 * 			ProviderName:      pulumi.String("myattestationprovider"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"Property1": pulumi.String("Value1"),
 * 				"Property2": pulumi.String("Value2"),
 * 				"Property3": pulumi.String("Value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.attestation.AttestationProvider;
 * import com.pulumi.azurenative.attestation.AttestationProviderArgs;
 * import com.pulumi.azurenative.attestation.inputs.AttestationServiceCreationSpecificParamsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attestationProvider = new AttestationProvider("attestationProvider", AttestationProviderArgs.builder()
 *             .location("East US")
 *             .properties(AttestationServiceCreationSpecificParamsArgs.builder()
 *                 .publicNetworkAccess("Enabled")
 *                 .tpmAttestationAuthentication("Enabled")
 *                 .build())
 *             .providerName("myattestationprovider")
 *             .resourceGroupName("MyResourceGroup")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Property1", "Value1"),
 *                 Map.entry("Property2", "Value2"),
 *                 Map.entry("Property3", "Value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:attestation:AttestationProvider myattestationprovider /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Attestation/attestationProviders/{providerName}
 * ```
 * @property location The supported Azure location where the attestation provider should be created.
 * @property properties Properties of the attestation provider
 * @property providerName Name of the attestation provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags The tags that will be assigned to the attestation provider.
 */
public data class AttestationProviderArgs(
    public val location: Output<String>? = null,
    public val properties: Output<AttestationServiceCreationSpecificParamsArgs>? = null,
    public val providerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.attestation.AttestationProviderArgs> {
    override fun toJava(): com.pulumi.azurenative.attestation.AttestationProviderArgs =
        com.pulumi.azurenative.attestation.AttestationProviderArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AttestationProviderArgs].
 */
@PulumiTagMarker
public class AttestationProviderArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<AttestationServiceCreationSpecificParamsArgs>? = null

    private var providerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The supported Azure location where the attestation provider should be created.
     */
    @JvmName("ntdnqksvigbcesal")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of the attestation provider
     */
    @JvmName("yaekotkclktiguek")
    public suspend fun properties(`value`: Output<AttestationServiceCreationSpecificParamsArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the attestation provider.
     */
    @JvmName("ykhphonbmnrrnpbc")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hbbwdrwttvgmmlna")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags that will be assigned to the attestation provider.
     */
    @JvmName("lkdromrencytodur")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The supported Azure location where the attestation provider should be created.
     */
    @JvmName("tdwcayyiqllfrowk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of the attestation provider
     */
    @JvmName("taipcntlfphwgmti")
    public suspend fun properties(`value`: AttestationServiceCreationSpecificParamsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the attestation provider
     */
    @JvmName("dondjixucorjkgon")
    public suspend fun properties(argument: suspend AttestationServiceCreationSpecificParamsArgsBuilder.() -> Unit) {
        val toBeMapped = AttestationServiceCreationSpecificParamsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the attestation provider.
     */
    @JvmName("rrlxullxgmmhepsx")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("agmwgpqfsoagwfpu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags that will be assigned to the attestation provider.
     */
    @JvmName("gnyvlrsvixbimaqt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags that will be assigned to the attestation provider.
     */
    @JvmName("sgciklkcquembrik")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AttestationProviderArgs = AttestationProviderArgs(
        location = location,
        properties = properties,
        providerName = providerName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
