@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.attestation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Controls whether traffic from the public network is allowed to access the Attestation Provider APIs.
 */
public enum class PublicNetworkAccessType(
    public val javaValue: com.pulumi.azurenative.attestation.enums.PublicNetworkAccessType,
) : ConvertibleToJava<com.pulumi.azurenative.attestation.enums.PublicNetworkAccessType> {
    /**
     * Enables public network connectivity to the Attestation Provider REST APIs.
     */
    Enabled(com.pulumi.azurenative.attestation.enums.PublicNetworkAccessType.Enabled),

    /**
     * Disables public network connectivity to the Attestation Provider REST APIs.
     */
    Disabled(com.pulumi.azurenative.attestation.enums.PublicNetworkAccessType.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.attestation.enums.PublicNetworkAccessType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.attestation.enums.PublicNetworkAccessType): PublicNetworkAccessType =
            PublicNetworkAccessType.values().first { it.javaValue == javaType }
    }
}
