@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.attestation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The setting that controls whether authentication is enabled or disabled for TPM Attestation REST APIs.
 */
public enum class TpmAttestationAuthenticationType(
    public val javaValue: com.pulumi.azurenative.attestation.enums.TpmAttestationAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.attestation.enums.TpmAttestationAuthenticationType> {
    /**
     * Enables the requirement of authentication for TPM Attestation REST APIs.
     */
    Enabled(com.pulumi.azurenative.attestation.enums.TpmAttestationAuthenticationType.Enabled),

    /**
     * Disables the requirement of authentication for TPM Attestation REST APIs.
     */
    Disabled(com.pulumi.azurenative.attestation.enums.TpmAttestationAuthenticationType.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.attestation.enums.TpmAttestationAuthenticationType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.attestation.enums.TpmAttestationAuthenticationType): TpmAttestationAuthenticationType =
            TpmAttestationAuthenticationType.values().first { it.javaValue == javaType }
    }
}
