@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewHistoryInstanceResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewScopeResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewHistoryInstanceResponse.Companion.toKotlin as accessReviewHistoryInstanceResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewScopeResponse.Companion.toKotlin as accessReviewScopeResponseToKotlin

/**
 * Builder for [AccessReviewHistoryDefinitionById].
 */
@PulumiTagMarker
public class AccessReviewHistoryDefinitionByIdResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessReviewHistoryDefinitionByIdArgs = AccessReviewHistoryDefinitionByIdArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessReviewHistoryDefinitionByIdArgsBuilder.() -> Unit) {
        val builder = AccessReviewHistoryDefinitionByIdArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessReviewHistoryDefinitionById {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.AccessReviewHistoryDefinitionById(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessReviewHistoryDefinitionById(builtJavaResource)
    }
}

/**
 * Access Review History Definition.
 * Azure REST API version: 2021-12-01-preview. Prior API version in Azure Native 1.x: 2021-11-16-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:AccessReviewHistoryDefinitionById myresource1 /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/accessReviewHistoryDefinitions/{historyDefinitionId}
 * ```
 */
public class AccessReviewHistoryDefinitionById internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.AccessReviewHistoryDefinitionById,
) : KotlinCustomResource(javaResource, AccessReviewHistoryDefinitionByIdMapper) {
    /**
     * Date time when history definition was created
     */
    public val createdDateTime: Output<String>
        get() = javaResource.createdDateTime().applyValue({ args0 -> args0 })

    /**
     * Collection of review decisions which the history data should be filtered on. For example if Approve and Deny are supplied the data will only contain review results in which the decision maker approved or denied a review request.
     */
    public val decisions: Output<List<String>>?
        get() = javaResource.decisions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The display name for the history definition.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The DateTime when the review is scheduled to end. Required if type is endDate
     */
    public val endDate: Output<String>?
        get() = javaResource.endDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Set of access review history instances for this history definition.
     */
    public val instances: Output<List<AccessReviewHistoryInstanceResponse>>?
        get() = javaResource.instances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> accessReviewHistoryInstanceResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
     */
    public val interval: Output<Int>?
        get() = javaResource.interval().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The access review history definition unique id.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of times to repeat the access review. Required and must be positive if type is numbered.
     */
    public val numberOfOccurrences: Output<Int>?
        get() = javaResource.numberOfOccurrences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identity id
     */
    public val principalId: Output<String>
        get() = javaResource.principalId().applyValue({ args0 -> args0 })

    /**
     * The identity display name
     */
    public val principalName: Output<String>
        get() = javaResource.principalName().applyValue({ args0 -> args0 })

    /**
     * The identity type : user/servicePrincipal
     */
    public val principalType: Output<String>
        get() = javaResource.principalType().applyValue({ args0 -> args0 })

    /**
     * Date time used when selecting review data, all reviews included in data end on or before this date. For use only with one-time/non-recurring reports.
     */
    public val reviewHistoryPeriodEndDateTime: Output<String>
        get() = javaResource.reviewHistoryPeriodEndDateTime().applyValue({ args0 -> args0 })

    /**
     * Date time used when selecting review data, all reviews included in data start on or after this date. For use only with one-time/non-recurring reports.
     */
    public val reviewHistoryPeriodStartDateTime: Output<String>
        get() = javaResource.reviewHistoryPeriodStartDateTime().applyValue({ args0 -> args0 })

    /**
     * A collection of scopes used when selecting review history data
     */
    public val scopes: Output<List<AccessReviewScopeResponse>>?
        get() = javaResource.scopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> accessReviewScopeResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
     */
    public val startDate: Output<String>?
        get() = javaResource.startDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This read-only field specifies the of the requested review history data. This is either requested, in-progress, done or error.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The user principal name(if valid)
     */
    public val userPrincipalName: Output<String>
        get() = javaResource.userPrincipalName().applyValue({ args0 -> args0 })
}

public object AccessReviewHistoryDefinitionByIdMapper :
    ResourceMapper<AccessReviewHistoryDefinitionById> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.AccessReviewHistoryDefinitionById::class == javaResource::class

    override fun map(javaResource: Resource): AccessReviewHistoryDefinitionById =
        AccessReviewHistoryDefinitionById(
            javaResource as
                com.pulumi.azurenative.authorization.AccessReviewHistoryDefinitionById,
        )
}

/**
 * @see [AccessReviewHistoryDefinitionById].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessReviewHistoryDefinitionById].
 */
public suspend fun accessReviewHistoryDefinitionById(
    name: String,
    block: suspend AccessReviewHistoryDefinitionByIdResourceBuilder.() -> Unit,
): AccessReviewHistoryDefinitionById {
    val builder = AccessReviewHistoryDefinitionByIdResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessReviewHistoryDefinitionById].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessReviewHistoryDefinitionById(name: String): AccessReviewHistoryDefinitionById {
    val builder = AccessReviewHistoryDefinitionByIdResourceBuilder()
    builder.name(name)
    return builder.build()
}
