@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.AuthorizationFunctions.getAccessReviewHistoryDefinitionByIdPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getAccessReviewScheduleDefinitionByIdPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getClientConfigPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getClientTokenPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getManagementLockAtResourceGroupLevelPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getManagementLockAtResourceLevelPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getManagementLockAtSubscriptionLevelPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getManagementLockByScopePlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getPolicyAssignmentPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getPolicyDefinitionAtManagementGroupPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getPolicyDefinitionPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getPolicyDefinitionVersionAtManagementGroupPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getPolicyDefinitionVersionPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getPolicyExemptionPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getPolicySetDefinitionAtManagementGroupPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getPolicySetDefinitionPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getPolicySetDefinitionVersionAtManagementGroupPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getPolicySetDefinitionVersionPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getPrivateLinkAssociationPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getResourceManagementPrivateLinkPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getRoleAssignmentPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getRoleDefinitionPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getRoleManagementPolicyAssignmentPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getScopeAccessReviewHistoryDefinitionByIdPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getScopeAccessReviewScheduleDefinitionByIdPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getVariableAtManagementGroupPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getVariablePlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getVariableValueAtManagementGroupPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.getVariableValuePlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.listPolicyDefinitionVersionAllAtManagementGroupPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.listPolicyDefinitionVersionAllBuiltinsPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.listPolicyDefinitionVersionAllPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.listPolicySetDefinitionVersionAllAtManagementGroupPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.listPolicySetDefinitionVersionAllBuiltinsPlain
import com.pulumi.azurenative.authorization.AuthorizationFunctions.listPolicySetDefinitionVersionAllPlain
import com.pulumi.azurenative.authorization.kotlin.inputs.GetAccessReviewHistoryDefinitionByIdPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetAccessReviewHistoryDefinitionByIdPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetAccessReviewScheduleDefinitionByIdPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetAccessReviewScheduleDefinitionByIdPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetClientTokenPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetClientTokenPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetManagementLockAtResourceGroupLevelPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetManagementLockAtResourceGroupLevelPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetManagementLockAtResourceLevelPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetManagementLockAtResourceLevelPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetManagementLockAtSubscriptionLevelPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetManagementLockAtSubscriptionLevelPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetManagementLockByScopePlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetManagementLockByScopePlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicyAssignmentPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicyAssignmentPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicyDefinitionAtManagementGroupPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicyDefinitionAtManagementGroupPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicyDefinitionPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicyDefinitionPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicyDefinitionVersionAtManagementGroupPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicyDefinitionVersionAtManagementGroupPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicyDefinitionVersionPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicyDefinitionVersionPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicyExemptionPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicyExemptionPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicySetDefinitionAtManagementGroupPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicySetDefinitionAtManagementGroupPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicySetDefinitionPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicySetDefinitionPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicySetDefinitionVersionAtManagementGroupPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicySetDefinitionVersionAtManagementGroupPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicySetDefinitionVersionPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPolicySetDefinitionVersionPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPrivateLinkAssociationPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetPrivateLinkAssociationPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetResourceManagementPrivateLinkPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetResourceManagementPrivateLinkPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetRoleAssignmentPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetRoleAssignmentPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetRoleDefinitionPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetRoleDefinitionPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetRoleManagementPolicyAssignmentPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetRoleManagementPolicyAssignmentPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetScopeAccessReviewHistoryDefinitionByIdPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetScopeAccessReviewHistoryDefinitionByIdPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetScopeAccessReviewScheduleDefinitionByIdPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetScopeAccessReviewScheduleDefinitionByIdPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetVariableAtManagementGroupPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetVariableAtManagementGroupPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetVariablePlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetVariablePlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetVariableValueAtManagementGroupPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetVariableValueAtManagementGroupPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.GetVariableValuePlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.GetVariableValuePlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.ListPolicyDefinitionVersionAllAtManagementGroupPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ListPolicyDefinitionVersionAllAtManagementGroupPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.outputs.GetAccessReviewHistoryDefinitionByIdResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetAccessReviewScheduleDefinitionByIdResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetClientConfigResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetClientTokenResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetManagementLockAtResourceGroupLevelResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetManagementLockAtResourceLevelResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetManagementLockAtSubscriptionLevelResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetManagementLockByScopeResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicyAssignmentResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicyDefinitionAtManagementGroupResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicyDefinitionResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicyDefinitionVersionAtManagementGroupResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicyDefinitionVersionResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicyExemptionResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicySetDefinitionAtManagementGroupResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicySetDefinitionResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicySetDefinitionVersionAtManagementGroupResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicySetDefinitionVersionResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPrivateLinkAssociationResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetResourceManagementPrivateLinkResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetRoleAssignmentResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetRoleDefinitionResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetRoleManagementPolicyAssignmentResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetScopeAccessReviewHistoryDefinitionByIdResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetScopeAccessReviewScheduleDefinitionByIdResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetVariableAtManagementGroupResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetVariableResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetVariableValueAtManagementGroupResult
import com.pulumi.azurenative.authorization.kotlin.outputs.GetVariableValueResult
import com.pulumi.azurenative.authorization.kotlin.outputs.ListPolicyDefinitionVersionAllAtManagementGroupResult
import com.pulumi.azurenative.authorization.kotlin.outputs.ListPolicyDefinitionVersionAllBuiltinsResult
import com.pulumi.azurenative.authorization.kotlin.outputs.ListPolicyDefinitionVersionAllResult
import com.pulumi.azurenative.authorization.kotlin.outputs.ListPolicySetDefinitionVersionAllAtManagementGroupResult
import com.pulumi.azurenative.authorization.kotlin.outputs.ListPolicySetDefinitionVersionAllBuiltinsResult
import com.pulumi.azurenative.authorization.kotlin.outputs.ListPolicySetDefinitionVersionAllResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.authorization.kotlin.outputs.GetAccessReviewHistoryDefinitionByIdResult.Companion.toKotlin as getAccessReviewHistoryDefinitionByIdResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetAccessReviewScheduleDefinitionByIdResult.Companion.toKotlin as getAccessReviewScheduleDefinitionByIdResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetClientConfigResult.Companion.toKotlin as getClientConfigResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetClientTokenResult.Companion.toKotlin as getClientTokenResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetManagementLockAtResourceGroupLevelResult.Companion.toKotlin as getManagementLockAtResourceGroupLevelResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetManagementLockAtResourceLevelResult.Companion.toKotlin as getManagementLockAtResourceLevelResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetManagementLockAtSubscriptionLevelResult.Companion.toKotlin as getManagementLockAtSubscriptionLevelResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetManagementLockByScopeResult.Companion.toKotlin as getManagementLockByScopeResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicyAssignmentResult.Companion.toKotlin as getPolicyAssignmentResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicyDefinitionAtManagementGroupResult.Companion.toKotlin as getPolicyDefinitionAtManagementGroupResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicyDefinitionResult.Companion.toKotlin as getPolicyDefinitionResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicyDefinitionVersionAtManagementGroupResult.Companion.toKotlin as getPolicyDefinitionVersionAtManagementGroupResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicyDefinitionVersionResult.Companion.toKotlin as getPolicyDefinitionVersionResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicyExemptionResult.Companion.toKotlin as getPolicyExemptionResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicySetDefinitionAtManagementGroupResult.Companion.toKotlin as getPolicySetDefinitionAtManagementGroupResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicySetDefinitionResult.Companion.toKotlin as getPolicySetDefinitionResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicySetDefinitionVersionAtManagementGroupResult.Companion.toKotlin as getPolicySetDefinitionVersionAtManagementGroupResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPolicySetDefinitionVersionResult.Companion.toKotlin as getPolicySetDefinitionVersionResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetPrivateLinkAssociationResult.Companion.toKotlin as getPrivateLinkAssociationResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetResourceManagementPrivateLinkResult.Companion.toKotlin as getResourceManagementPrivateLinkResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetRoleAssignmentResult.Companion.toKotlin as getRoleAssignmentResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetRoleDefinitionResult.Companion.toKotlin as getRoleDefinitionResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetRoleManagementPolicyAssignmentResult.Companion.toKotlin as getRoleManagementPolicyAssignmentResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetScopeAccessReviewHistoryDefinitionByIdResult.Companion.toKotlin as getScopeAccessReviewHistoryDefinitionByIdResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetScopeAccessReviewScheduleDefinitionByIdResult.Companion.toKotlin as getScopeAccessReviewScheduleDefinitionByIdResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetVariableAtManagementGroupResult.Companion.toKotlin as getVariableAtManagementGroupResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetVariableResult.Companion.toKotlin as getVariableResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetVariableValueAtManagementGroupResult.Companion.toKotlin as getVariableValueAtManagementGroupResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.GetVariableValueResult.Companion.toKotlin as getVariableValueResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.ListPolicyDefinitionVersionAllAtManagementGroupResult.Companion.toKotlin as listPolicyDefinitionVersionAllAtManagementGroupResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.ListPolicyDefinitionVersionAllBuiltinsResult.Companion.toKotlin as listPolicyDefinitionVersionAllBuiltinsResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.ListPolicyDefinitionVersionAllResult.Companion.toKotlin as listPolicyDefinitionVersionAllResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.ListPolicySetDefinitionVersionAllAtManagementGroupResult.Companion.toKotlin as listPolicySetDefinitionVersionAllAtManagementGroupResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.ListPolicySetDefinitionVersionAllBuiltinsResult.Companion.toKotlin as listPolicySetDefinitionVersionAllBuiltinsResultToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.ListPolicySetDefinitionVersionAllResult.Companion.toKotlin as listPolicySetDefinitionVersionAllResultToKotlin

public object AuthorizationFunctions {
    /**
     * Get access review history definition by definition Id
     * Azure REST API version: 2021-12-01-preview.
     * @param argument null
     * @return Access Review History Definition.
     */
    public suspend fun getAccessReviewHistoryDefinitionById(argument: GetAccessReviewHistoryDefinitionByIdPlainArgs): GetAccessReviewHistoryDefinitionByIdResult =
        getAccessReviewHistoryDefinitionByIdResultToKotlin(getAccessReviewHistoryDefinitionByIdPlain(argument.toJava()).await())

    /**
     * @see [getAccessReviewHistoryDefinitionById].
     * @param historyDefinitionId The id of the access review history definition.
     * @return Access Review History Definition.
     */
    public suspend fun getAccessReviewHistoryDefinitionById(historyDefinitionId: String): GetAccessReviewHistoryDefinitionByIdResult {
        val argument = GetAccessReviewHistoryDefinitionByIdPlainArgs(
            historyDefinitionId = historyDefinitionId,
        )
        return getAccessReviewHistoryDefinitionByIdResultToKotlin(getAccessReviewHistoryDefinitionByIdPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessReviewHistoryDefinitionById].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetAccessReviewHistoryDefinitionByIdPlainArgs].
     * @return Access Review History Definition.
     */
    public suspend fun getAccessReviewHistoryDefinitionById(argument: suspend GetAccessReviewHistoryDefinitionByIdPlainArgsBuilder.() -> Unit): GetAccessReviewHistoryDefinitionByIdResult {
        val builder = GetAccessReviewHistoryDefinitionByIdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessReviewHistoryDefinitionByIdResultToKotlin(getAccessReviewHistoryDefinitionByIdPlain(builtArgument.toJava()).await())
    }

    /**
     * Get single access review definition
     * Azure REST API version: 2021-12-01-preview.
     * @param argument null
     * @return Access Review Schedule Definition.
     */
    public suspend fun getAccessReviewScheduleDefinitionById(argument: GetAccessReviewScheduleDefinitionByIdPlainArgs): GetAccessReviewScheduleDefinitionByIdResult =
        getAccessReviewScheduleDefinitionByIdResultToKotlin(getAccessReviewScheduleDefinitionByIdPlain(argument.toJava()).await())

    /**
     * @see [getAccessReviewScheduleDefinitionById].
     * @param scheduleDefinitionId The id of the access review schedule definition.
     * @return Access Review Schedule Definition.
     */
    public suspend fun getAccessReviewScheduleDefinitionById(scheduleDefinitionId: String): GetAccessReviewScheduleDefinitionByIdResult {
        val argument = GetAccessReviewScheduleDefinitionByIdPlainArgs(
            scheduleDefinitionId = scheduleDefinitionId,
        )
        return getAccessReviewScheduleDefinitionByIdResultToKotlin(getAccessReviewScheduleDefinitionByIdPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessReviewScheduleDefinitionById].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetAccessReviewScheduleDefinitionByIdPlainArgs].
     * @return Access Review Schedule Definition.
     */
    public suspend fun getAccessReviewScheduleDefinitionById(argument: suspend GetAccessReviewScheduleDefinitionByIdPlainArgsBuilder.() -> Unit): GetAccessReviewScheduleDefinitionByIdResult {
        val builder = GetAccessReviewScheduleDefinitionByIdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessReviewScheduleDefinitionByIdResultToKotlin(getAccessReviewScheduleDefinitionByIdPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this function to access the current configuration of the native Azure provider.
     * @param argument Use this function to access the current configuration of the native Azure provider.
     * @return Configuration values returned by getClientConfig.
     */
    public suspend fun getClientConfig(): GetClientConfigResult =
        getClientConfigResultToKotlin(getClientConfigPlain().await())

    /**
     * Use this function to get an Azure authentication token for the current login context.
     * @param argument null
     * @return Configuration values returned by getClientToken.
     */
    public suspend fun getClientToken(argument: GetClientTokenPlainArgs): GetClientTokenResult =
        getClientTokenResultToKotlin(getClientTokenPlain(argument.toJava()).await())

    /**
     * @see [getClientToken].
     * @param endpoint Optional authentication endpoint. Defaults to the endpoint of Azure Resource Manager.
     * @return Configuration values returned by getClientToken.
     */
    public suspend fun getClientToken(endpoint: String? = null): GetClientTokenResult {
        val argument = GetClientTokenPlainArgs(
            endpoint = endpoint,
        )
        return getClientTokenResultToKotlin(getClientTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getClientToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetClientTokenPlainArgs].
     * @return Configuration values returned by getClientToken.
     */
    public suspend fun getClientToken(argument: suspend GetClientTokenPlainArgsBuilder.() -> Unit): GetClientTokenResult {
        val builder = GetClientTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClientTokenResultToKotlin(getClientTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a management lock at the resource group level.
     * Azure REST API version: 2020-05-01.
     * Other available API versions: 2015-01-01.
     * @param argument null
     * @return The lock information.
     */
    public suspend fun getManagementLockAtResourceGroupLevel(argument: GetManagementLockAtResourceGroupLevelPlainArgs): GetManagementLockAtResourceGroupLevelResult =
        getManagementLockAtResourceGroupLevelResultToKotlin(getManagementLockAtResourceGroupLevelPlain(argument.toJava()).await())

    /**
     * @see [getManagementLockAtResourceGroupLevel].
     * @param lockName The name of the lock to get.
     * @param resourceGroupName The name of the locked resource group.
     * @return The lock information.
     */
    public suspend fun getManagementLockAtResourceGroupLevel(
        lockName: String,
        resourceGroupName: String,
    ): GetManagementLockAtResourceGroupLevelResult {
        val argument = GetManagementLockAtResourceGroupLevelPlainArgs(
            lockName = lockName,
            resourceGroupName = resourceGroupName,
        )
        return getManagementLockAtResourceGroupLevelResultToKotlin(getManagementLockAtResourceGroupLevelPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagementLockAtResourceGroupLevel].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetManagementLockAtResourceGroupLevelPlainArgs].
     * @return The lock information.
     */
    public suspend fun getManagementLockAtResourceGroupLevel(argument: suspend GetManagementLockAtResourceGroupLevelPlainArgsBuilder.() -> Unit): GetManagementLockAtResourceGroupLevelResult {
        val builder = GetManagementLockAtResourceGroupLevelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagementLockAtResourceGroupLevelResultToKotlin(getManagementLockAtResourceGroupLevelPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the management lock of a resource or any level below resource.
     * Azure REST API version: 2020-05-01.
     * @param argument null
     * @return The lock information.
     */
    public suspend fun getManagementLockAtResourceLevel(argument: GetManagementLockAtResourceLevelPlainArgs): GetManagementLockAtResourceLevelResult =
        getManagementLockAtResourceLevelResultToKotlin(getManagementLockAtResourceLevelPlain(argument.toJava()).await())

    /**
     * @see [getManagementLockAtResourceLevel].
     * @param lockName The name of lock.
     * @param parentResourcePath An extra path parameter needed in some services, like SQL Databases.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the resource.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param resourceType The type of the resource.
     * @return The lock information.
     */
    public suspend fun getManagementLockAtResourceLevel(
        lockName: String,
        parentResourcePath: String,
        resourceGroupName: String,
        resourceName: String,
        resourceProviderNamespace: String,
        resourceType: String,
    ): GetManagementLockAtResourceLevelResult {
        val argument = GetManagementLockAtResourceLevelPlainArgs(
            lockName = lockName,
            parentResourcePath = parentResourcePath,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            resourceProviderNamespace = resourceProviderNamespace,
            resourceType = resourceType,
        )
        return getManagementLockAtResourceLevelResultToKotlin(getManagementLockAtResourceLevelPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagementLockAtResourceLevel].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetManagementLockAtResourceLevelPlainArgs].
     * @return The lock information.
     */
    public suspend fun getManagementLockAtResourceLevel(argument: suspend GetManagementLockAtResourceLevelPlainArgsBuilder.() -> Unit): GetManagementLockAtResourceLevelResult {
        val builder = GetManagementLockAtResourceLevelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagementLockAtResourceLevelResultToKotlin(getManagementLockAtResourceLevelPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a management lock at the subscription level.
     * Azure REST API version: 2020-05-01.
     * @param argument null
     * @return The lock information.
     */
    public suspend fun getManagementLockAtSubscriptionLevel(argument: GetManagementLockAtSubscriptionLevelPlainArgs): GetManagementLockAtSubscriptionLevelResult =
        getManagementLockAtSubscriptionLevelResultToKotlin(getManagementLockAtSubscriptionLevelPlain(argument.toJava()).await())

    /**
     * @see [getManagementLockAtSubscriptionLevel].
     * @param lockName The name of the lock to get.
     * @return The lock information.
     */
    public suspend fun getManagementLockAtSubscriptionLevel(lockName: String): GetManagementLockAtSubscriptionLevelResult {
        val argument = GetManagementLockAtSubscriptionLevelPlainArgs(
            lockName = lockName,
        )
        return getManagementLockAtSubscriptionLevelResultToKotlin(getManagementLockAtSubscriptionLevelPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagementLockAtSubscriptionLevel].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetManagementLockAtSubscriptionLevelPlainArgs].
     * @return The lock information.
     */
    public suspend fun getManagementLockAtSubscriptionLevel(argument: suspend GetManagementLockAtSubscriptionLevelPlainArgsBuilder.() -> Unit): GetManagementLockAtSubscriptionLevelResult {
        val builder = GetManagementLockAtSubscriptionLevelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagementLockAtSubscriptionLevelResultToKotlin(getManagementLockAtSubscriptionLevelPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a management lock by scope.
     * Azure REST API version: 2020-05-01.
     * @param argument null
     * @return The lock information.
     */
    public suspend fun getManagementLockByScope(argument: GetManagementLockByScopePlainArgs): GetManagementLockByScopeResult =
        getManagementLockByScopeResultToKotlin(getManagementLockByScopePlain(argument.toJava()).await())

    /**
     * @see [getManagementLockByScope].
     * @param lockName The name of lock.
     * @param scope The scope for the lock.
     * @return The lock information.
     */
    public suspend fun getManagementLockByScope(lockName: String, scope: String): GetManagementLockByScopeResult {
        val argument = GetManagementLockByScopePlainArgs(
            lockName = lockName,
            scope = scope,
        )
        return getManagementLockByScopeResultToKotlin(getManagementLockByScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getManagementLockByScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetManagementLockByScopePlainArgs].
     * @return The lock information.
     */
    public suspend fun getManagementLockByScope(argument: suspend GetManagementLockByScopePlainArgsBuilder.() -> Unit): GetManagementLockByScopeResult {
        val builder = GetManagementLockByScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagementLockByScopeResultToKotlin(getManagementLockByScopePlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves a single policy assignment, given its name and the scope it was created at.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2016-04-01, 2016-12-01, 2019-06-01, 2020-03-01, 2023-04-01, 2024-04-01.
     * @param argument null
     * @return The policy assignment.
     */
    public suspend fun getPolicyAssignment(argument: GetPolicyAssignmentPlainArgs): GetPolicyAssignmentResult =
        getPolicyAssignmentResultToKotlin(getPolicyAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getPolicyAssignment].
     * @param policyAssignmentName The name of the policy assignment to get.
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     * @return The policy assignment.
     */
    public suspend fun getPolicyAssignment(policyAssignmentName: String, scope: String): GetPolicyAssignmentResult {
        val argument = GetPolicyAssignmentPlainArgs(
            policyAssignmentName = policyAssignmentName,
            scope = scope,
        )
        return getPolicyAssignmentResultToKotlin(getPolicyAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetPolicyAssignmentPlainArgs].
     * @return The policy assignment.
     */
    public suspend fun getPolicyAssignment(argument: suspend GetPolicyAssignmentPlainArgsBuilder.() -> Unit): GetPolicyAssignmentResult {
        val builder = GetPolicyAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyAssignmentResultToKotlin(getPolicyAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves the policy definition in the given subscription with the given name.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2016-04-01, 2018-05-01, 2019-06-01, 2023-04-01.
     * @param argument null
     * @return The policy definition.
     */
    public suspend fun getPolicyDefinition(argument: GetPolicyDefinitionPlainArgs): GetPolicyDefinitionResult =
        getPolicyDefinitionResultToKotlin(getPolicyDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getPolicyDefinition].
     * @param policyDefinitionName The name of the policy definition to get.
     * @return The policy definition.
     */
    public suspend fun getPolicyDefinition(policyDefinitionName: String): GetPolicyDefinitionResult {
        val argument = GetPolicyDefinitionPlainArgs(
            policyDefinitionName = policyDefinitionName,
        )
        return getPolicyDefinitionResultToKotlin(getPolicyDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetPolicyDefinitionPlainArgs].
     * @return The policy definition.
     */
    public suspend fun getPolicyDefinition(argument: suspend GetPolicyDefinitionPlainArgsBuilder.() -> Unit): GetPolicyDefinitionResult {
        val builder = GetPolicyDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyDefinitionResultToKotlin(getPolicyDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves the policy definition in the given management group with the given name.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2018-05-01, 2019-06-01, 2023-04-01.
     * @param argument null
     * @return The policy definition.
     */
    public suspend fun getPolicyDefinitionAtManagementGroup(argument: GetPolicyDefinitionAtManagementGroupPlainArgs): GetPolicyDefinitionAtManagementGroupResult =
        getPolicyDefinitionAtManagementGroupResultToKotlin(getPolicyDefinitionAtManagementGroupPlain(argument.toJava()).await())

    /**
     * @see [getPolicyDefinitionAtManagementGroup].
     * @param managementGroupId The ID of the management group.
     * @param policyDefinitionName The name of the policy definition to get.
     * @return The policy definition.
     */
    public suspend fun getPolicyDefinitionAtManagementGroup(
        managementGroupId: String,
        policyDefinitionName: String,
    ): GetPolicyDefinitionAtManagementGroupResult {
        val argument = GetPolicyDefinitionAtManagementGroupPlainArgs(
            managementGroupId = managementGroupId,
            policyDefinitionName = policyDefinitionName,
        )
        return getPolicyDefinitionAtManagementGroupResultToKotlin(getPolicyDefinitionAtManagementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyDefinitionAtManagementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetPolicyDefinitionAtManagementGroupPlainArgs].
     * @return The policy definition.
     */
    public suspend fun getPolicyDefinitionAtManagementGroup(argument: suspend GetPolicyDefinitionAtManagementGroupPlainArgsBuilder.() -> Unit): GetPolicyDefinitionAtManagementGroupResult {
        val builder = GetPolicyDefinitionAtManagementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyDefinitionAtManagementGroupResultToKotlin(getPolicyDefinitionAtManagementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves the policy definition version in the given subscription with the given name.
     * Azure REST API version: 2023-04-01.
     * @param argument null
     * @return The ID of the policy definition version.
     */
    public suspend fun getPolicyDefinitionVersion(argument: GetPolicyDefinitionVersionPlainArgs): GetPolicyDefinitionVersionResult =
        getPolicyDefinitionVersionResultToKotlin(getPolicyDefinitionVersionPlain(argument.toJava()).await())

    /**
     * @see [getPolicyDefinitionVersion].
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     * @return The ID of the policy definition version.
     */
    public suspend fun getPolicyDefinitionVersion(
        policyDefinitionName: String,
        policyDefinitionVersion: String,
    ): GetPolicyDefinitionVersionResult {
        val argument = GetPolicyDefinitionVersionPlainArgs(
            policyDefinitionName = policyDefinitionName,
            policyDefinitionVersion = policyDefinitionVersion,
        )
        return getPolicyDefinitionVersionResultToKotlin(getPolicyDefinitionVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyDefinitionVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetPolicyDefinitionVersionPlainArgs].
     * @return The ID of the policy definition version.
     */
    public suspend fun getPolicyDefinitionVersion(argument: suspend GetPolicyDefinitionVersionPlainArgsBuilder.() -> Unit): GetPolicyDefinitionVersionResult {
        val builder = GetPolicyDefinitionVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyDefinitionVersionResultToKotlin(getPolicyDefinitionVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves the policy definition version in the given management group with the given name.
     * Azure REST API version: 2023-04-01.
     * @param argument null
     * @return The ID of the policy definition version.
     */
    public suspend fun getPolicyDefinitionVersionAtManagementGroup(argument: GetPolicyDefinitionVersionAtManagementGroupPlainArgs): GetPolicyDefinitionVersionAtManagementGroupResult =
        getPolicyDefinitionVersionAtManagementGroupResultToKotlin(getPolicyDefinitionVersionAtManagementGroupPlain(argument.toJava()).await())

    /**
     * @see [getPolicyDefinitionVersionAtManagementGroup].
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     * @return The ID of the policy definition version.
     */
    public suspend fun getPolicyDefinitionVersionAtManagementGroup(
        managementGroupName: String,
        policyDefinitionName: String,
        policyDefinitionVersion: String,
    ): GetPolicyDefinitionVersionAtManagementGroupResult {
        val argument = GetPolicyDefinitionVersionAtManagementGroupPlainArgs(
            managementGroupName = managementGroupName,
            policyDefinitionName = policyDefinitionName,
            policyDefinitionVersion = policyDefinitionVersion,
        )
        return getPolicyDefinitionVersionAtManagementGroupResultToKotlin(getPolicyDefinitionVersionAtManagementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyDefinitionVersionAtManagementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetPolicyDefinitionVersionAtManagementGroupPlainArgs].
     * @return The ID of the policy definition version.
     */
    public suspend fun getPolicyDefinitionVersionAtManagementGroup(argument: suspend GetPolicyDefinitionVersionAtManagementGroupPlainArgsBuilder.() -> Unit): GetPolicyDefinitionVersionAtManagementGroupResult {
        val builder = GetPolicyDefinitionVersionAtManagementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyDefinitionVersionAtManagementGroupResultToKotlin(getPolicyDefinitionVersionAtManagementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves a single policy exemption, given its name and the scope it was created at.
     * Azure REST API version: 2022-07-01-preview.
     * @param argument null
     * @return The policy exemption.
     */
    public suspend fun getPolicyExemption(argument: GetPolicyExemptionPlainArgs): GetPolicyExemptionResult =
        getPolicyExemptionResultToKotlin(getPolicyExemptionPlain(argument.toJava()).await())

    /**
     * @see [getPolicyExemption].
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     * @return The policy exemption.
     */
    public suspend fun getPolicyExemption(policyExemptionName: String, scope: String): GetPolicyExemptionResult {
        val argument = GetPolicyExemptionPlainArgs(
            policyExemptionName = policyExemptionName,
            scope = scope,
        )
        return getPolicyExemptionResultToKotlin(getPolicyExemptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyExemption].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetPolicyExemptionPlainArgs].
     * @return The policy exemption.
     */
    public suspend fun getPolicyExemption(argument: suspend GetPolicyExemptionPlainArgsBuilder.() -> Unit): GetPolicyExemptionResult {
        val builder = GetPolicyExemptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyExemptionResultToKotlin(getPolicyExemptionPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves the policy set definition in the given subscription with the given name.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2019-06-01, 2023-04-01.
     * @param argument null
     * @return The policy set definition.
     */
    public suspend fun getPolicySetDefinition(argument: GetPolicySetDefinitionPlainArgs): GetPolicySetDefinitionResult =
        getPolicySetDefinitionResultToKotlin(getPolicySetDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getPolicySetDefinition].
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @return The policy set definition.
     */
    public suspend fun getPolicySetDefinition(policySetDefinitionName: String): GetPolicySetDefinitionResult {
        val argument = GetPolicySetDefinitionPlainArgs(
            policySetDefinitionName = policySetDefinitionName,
        )
        return getPolicySetDefinitionResultToKotlin(getPolicySetDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicySetDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetPolicySetDefinitionPlainArgs].
     * @return The policy set definition.
     */
    public suspend fun getPolicySetDefinition(argument: suspend GetPolicySetDefinitionPlainArgsBuilder.() -> Unit): GetPolicySetDefinitionResult {
        val builder = GetPolicySetDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicySetDefinitionResultToKotlin(getPolicySetDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves the policy set definition in the given management group with the given name.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2019-06-01, 2023-04-01.
     * @param argument null
     * @return The policy set definition.
     */
    public suspend fun getPolicySetDefinitionAtManagementGroup(argument: GetPolicySetDefinitionAtManagementGroupPlainArgs): GetPolicySetDefinitionAtManagementGroupResult =
        getPolicySetDefinitionAtManagementGroupResultToKotlin(getPolicySetDefinitionAtManagementGroupPlain(argument.toJava()).await())

    /**
     * @see [getPolicySetDefinitionAtManagementGroup].
     * @param managementGroupId The ID of the management group.
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @return The policy set definition.
     */
    public suspend fun getPolicySetDefinitionAtManagementGroup(
        managementGroupId: String,
        policySetDefinitionName: String,
    ): GetPolicySetDefinitionAtManagementGroupResult {
        val argument = GetPolicySetDefinitionAtManagementGroupPlainArgs(
            managementGroupId = managementGroupId,
            policySetDefinitionName = policySetDefinitionName,
        )
        return getPolicySetDefinitionAtManagementGroupResultToKotlin(getPolicySetDefinitionAtManagementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicySetDefinitionAtManagementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetPolicySetDefinitionAtManagementGroupPlainArgs].
     * @return The policy set definition.
     */
    public suspend fun getPolicySetDefinitionAtManagementGroup(argument: suspend GetPolicySetDefinitionAtManagementGroupPlainArgsBuilder.() -> Unit): GetPolicySetDefinitionAtManagementGroupResult {
        val builder = GetPolicySetDefinitionAtManagementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicySetDefinitionAtManagementGroupResultToKotlin(getPolicySetDefinitionAtManagementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves the policy set definition version in the given subscription with the given name and version.
     * Azure REST API version: 2023-04-01.
     * @param argument null
     * @return The policy set definition version.
     */
    public suspend fun getPolicySetDefinitionVersion(argument: GetPolicySetDefinitionVersionPlainArgs): GetPolicySetDefinitionVersionResult =
        getPolicySetDefinitionVersionResultToKotlin(getPolicySetDefinitionVersionPlain(argument.toJava()).await())

    /**
     * @see [getPolicySetDefinitionVersion].
     * @param policyDefinitionVersion The policy set definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     * @param policySetDefinitionName The name of the policy set definition.
     * @return The policy set definition version.
     */
    public suspend fun getPolicySetDefinitionVersion(
        policyDefinitionVersion: String,
        policySetDefinitionName: String,
    ): GetPolicySetDefinitionVersionResult {
        val argument = GetPolicySetDefinitionVersionPlainArgs(
            policyDefinitionVersion = policyDefinitionVersion,
            policySetDefinitionName = policySetDefinitionName,
        )
        return getPolicySetDefinitionVersionResultToKotlin(getPolicySetDefinitionVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicySetDefinitionVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetPolicySetDefinitionVersionPlainArgs].
     * @return The policy set definition version.
     */
    public suspend fun getPolicySetDefinitionVersion(argument: suspend GetPolicySetDefinitionVersionPlainArgsBuilder.() -> Unit): GetPolicySetDefinitionVersionResult {
        val builder = GetPolicySetDefinitionVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicySetDefinitionVersionResultToKotlin(getPolicySetDefinitionVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves the policy set definition version in the given management group with the given name and version.
     * Azure REST API version: 2023-04-01.
     * @param argument null
     * @return The policy set definition version.
     */
    public suspend fun getPolicySetDefinitionVersionAtManagementGroup(argument: GetPolicySetDefinitionVersionAtManagementGroupPlainArgs): GetPolicySetDefinitionVersionAtManagementGroupResult =
        getPolicySetDefinitionVersionAtManagementGroupResultToKotlin(getPolicySetDefinitionVersionAtManagementGroupPlain(argument.toJava()).await())

    /**
     * @see [getPolicySetDefinitionVersionAtManagementGroup].
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionVersion The policy set definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     * @param policySetDefinitionName The name of the policy set definition.
     * @return The policy set definition version.
     */
    public suspend fun getPolicySetDefinitionVersionAtManagementGroup(
        managementGroupName: String,
        policyDefinitionVersion: String,
        policySetDefinitionName: String,
    ): GetPolicySetDefinitionVersionAtManagementGroupResult {
        val argument = GetPolicySetDefinitionVersionAtManagementGroupPlainArgs(
            managementGroupName = managementGroupName,
            policyDefinitionVersion = policyDefinitionVersion,
            policySetDefinitionName = policySetDefinitionName,
        )
        return getPolicySetDefinitionVersionAtManagementGroupResultToKotlin(getPolicySetDefinitionVersionAtManagementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicySetDefinitionVersionAtManagementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetPolicySetDefinitionVersionAtManagementGroupPlainArgs].
     * @return The policy set definition version.
     */
    public suspend fun getPolicySetDefinitionVersionAtManagementGroup(argument: suspend GetPolicySetDefinitionVersionAtManagementGroupPlainArgsBuilder.() -> Unit): GetPolicySetDefinitionVersionAtManagementGroupResult {
        val builder = GetPolicySetDefinitionVersionAtManagementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicySetDefinitionVersionAtManagementGroupResultToKotlin(getPolicySetDefinitionVersionAtManagementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a single private link association
     * Azure REST API version: 2020-05-01.
     * @param argument null
     * @return null
     */
    public suspend fun getPrivateLinkAssociation(argument: GetPrivateLinkAssociationPlainArgs): GetPrivateLinkAssociationResult =
        getPrivateLinkAssociationResultToKotlin(getPrivateLinkAssociationPlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkAssociation].
     * @param groupId The management group ID.
     * @param plaId The ID of the PLA
     * @return null
     */
    public suspend fun getPrivateLinkAssociation(groupId: String, plaId: String): GetPrivateLinkAssociationResult {
        val argument = GetPrivateLinkAssociationPlainArgs(
            groupId = groupId,
            plaId = plaId,
        )
        return getPrivateLinkAssociationResultToKotlin(getPrivateLinkAssociationPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkAssociation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetPrivateLinkAssociationPlainArgs].
     * @return null
     */
    public suspend fun getPrivateLinkAssociation(argument: suspend GetPrivateLinkAssociationPlainArgsBuilder.() -> Unit): GetPrivateLinkAssociationResult {
        val builder = GetPrivateLinkAssociationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkAssociationResultToKotlin(getPrivateLinkAssociationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a resource management private link(resource-level).
     * Azure REST API version: 2020-05-01.
     * @param argument null
     * @return null
     */
    public suspend fun getResourceManagementPrivateLink(argument: GetResourceManagementPrivateLinkPlainArgs): GetResourceManagementPrivateLinkResult =
        getResourceManagementPrivateLinkResultToKotlin(getResourceManagementPrivateLinkPlain(argument.toJava()).await())

    /**
     * @see [getResourceManagementPrivateLink].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param rmplName The name of the resource management private link.
     * @return null
     */
    public suspend fun getResourceManagementPrivateLink(resourceGroupName: String, rmplName: String): GetResourceManagementPrivateLinkResult {
        val argument = GetResourceManagementPrivateLinkPlainArgs(
            resourceGroupName = resourceGroupName,
            rmplName = rmplName,
        )
        return getResourceManagementPrivateLinkResultToKotlin(getResourceManagementPrivateLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceManagementPrivateLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetResourceManagementPrivateLinkPlainArgs].
     * @return null
     */
    public suspend fun getResourceManagementPrivateLink(argument: suspend GetResourceManagementPrivateLinkPlainArgsBuilder.() -> Unit): GetResourceManagementPrivateLinkResult {
        val builder = GetResourceManagementPrivateLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceManagementPrivateLinkResultToKotlin(getResourceManagementPrivateLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a role assignment by scope and name.
     * Azure REST API version: 2022-04-01.
     * Other available API versions: 2015-07-01, 2017-10-01-preview, 2020-03-01-preview, 2020-04-01-preview.
     * @param argument null
     * @return Role Assignments
     */
    public suspend fun getRoleAssignment(argument: GetRoleAssignmentPlainArgs): GetRoleAssignmentResult =
        getRoleAssignmentResultToKotlin(getRoleAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getRoleAssignment].
     * @param roleAssignmentName The name of the role assignment. It can be any valid GUID.
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     * @param tenantId Tenant ID for cross-tenant request
     * @return Role Assignments
     */
    public suspend fun getRoleAssignment(
        roleAssignmentName: String,
        scope: String,
        tenantId: String? = null,
    ): GetRoleAssignmentResult {
        val argument = GetRoleAssignmentPlainArgs(
            roleAssignmentName = roleAssignmentName,
            scope = scope,
            tenantId = tenantId,
        )
        return getRoleAssignmentResultToKotlin(getRoleAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getRoleAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetRoleAssignmentPlainArgs].
     * @return Role Assignments
     */
    public suspend fun getRoleAssignment(argument: suspend GetRoleAssignmentPlainArgsBuilder.() -> Unit): GetRoleAssignmentResult {
        val builder = GetRoleAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRoleAssignmentResultToKotlin(getRoleAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get role definition by ID (GUID).
     * Azure REST API version: 2022-05-01-preview.
     * @param argument null
     * @return Role definition.
     */
    public suspend fun getRoleDefinition(argument: GetRoleDefinitionPlainArgs): GetRoleDefinitionResult =
        getRoleDefinitionResultToKotlin(getRoleDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getRoleDefinition].
     * @param roleDefinitionId The ID of the role definition.
     * @param scope The scope of the operation or resource. Valid scopes are: subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     * @return Role definition.
     */
    public suspend fun getRoleDefinition(roleDefinitionId: String, scope: String): GetRoleDefinitionResult {
        val argument = GetRoleDefinitionPlainArgs(
            roleDefinitionId = roleDefinitionId,
            scope = scope,
        )
        return getRoleDefinitionResultToKotlin(getRoleDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getRoleDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetRoleDefinitionPlainArgs].
     * @return Role definition.
     */
    public suspend fun getRoleDefinition(argument: suspend GetRoleDefinitionPlainArgsBuilder.() -> Unit): GetRoleDefinitionResult {
        val builder = GetRoleDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRoleDefinitionResultToKotlin(getRoleDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the specified role management policy assignment for a resource scope
     * Azure REST API version: 2020-10-01.
     * Other available API versions: 2020-10-01-preview.
     * @param argument null
     * @return Role management policy
     */
    public suspend fun getRoleManagementPolicyAssignment(argument: GetRoleManagementPolicyAssignmentPlainArgs): GetRoleManagementPolicyAssignmentResult =
        getRoleManagementPolicyAssignmentResultToKotlin(getRoleManagementPolicyAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getRoleManagementPolicyAssignment].
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to get.
     * @param scope The scope of the role management policy.
     * @return Role management policy
     */
    public suspend fun getRoleManagementPolicyAssignment(
        roleManagementPolicyAssignmentName: String,
        scope: String,
    ): GetRoleManagementPolicyAssignmentResult {
        val argument = GetRoleManagementPolicyAssignmentPlainArgs(
            roleManagementPolicyAssignmentName = roleManagementPolicyAssignmentName,
            scope = scope,
        )
        return getRoleManagementPolicyAssignmentResultToKotlin(getRoleManagementPolicyAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getRoleManagementPolicyAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetRoleManagementPolicyAssignmentPlainArgs].
     * @return Role management policy
     */
    public suspend fun getRoleManagementPolicyAssignment(argument: suspend GetRoleManagementPolicyAssignmentPlainArgsBuilder.() -> Unit): GetRoleManagementPolicyAssignmentResult {
        val builder = GetRoleManagementPolicyAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRoleManagementPolicyAssignmentResultToKotlin(getRoleManagementPolicyAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get access review history definition by definition Id
     * Azure REST API version: 2021-12-01-preview.
     * @param argument null
     * @return Access Review History Definition.
     */
    public suspend fun getScopeAccessReviewHistoryDefinitionById(argument: GetScopeAccessReviewHistoryDefinitionByIdPlainArgs): GetScopeAccessReviewHistoryDefinitionByIdResult =
        getScopeAccessReviewHistoryDefinitionByIdResultToKotlin(getScopeAccessReviewHistoryDefinitionByIdPlain(argument.toJava()).await())

    /**
     * @see [getScopeAccessReviewHistoryDefinitionById].
     * @param historyDefinitionId The id of the access review history definition.
     * @param scope The scope of the resource.
     * @return Access Review History Definition.
     */
    public suspend fun getScopeAccessReviewHistoryDefinitionById(
        historyDefinitionId: String,
        scope: String,
    ): GetScopeAccessReviewHistoryDefinitionByIdResult {
        val argument = GetScopeAccessReviewHistoryDefinitionByIdPlainArgs(
            historyDefinitionId = historyDefinitionId,
            scope = scope,
        )
        return getScopeAccessReviewHistoryDefinitionByIdResultToKotlin(getScopeAccessReviewHistoryDefinitionByIdPlain(argument.toJava()).await())
    }

    /**
     * @see [getScopeAccessReviewHistoryDefinitionById].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetScopeAccessReviewHistoryDefinitionByIdPlainArgs].
     * @return Access Review History Definition.
     */
    public suspend fun getScopeAccessReviewHistoryDefinitionById(argument: suspend GetScopeAccessReviewHistoryDefinitionByIdPlainArgsBuilder.() -> Unit): GetScopeAccessReviewHistoryDefinitionByIdResult {
        val builder = GetScopeAccessReviewHistoryDefinitionByIdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScopeAccessReviewHistoryDefinitionByIdResultToKotlin(getScopeAccessReviewHistoryDefinitionByIdPlain(builtArgument.toJava()).await())
    }

    /**
     * Get single access review definition
     * Azure REST API version: 2021-12-01-preview.
     * @param argument null
     * @return Access Review Schedule Definition.
     */
    public suspend fun getScopeAccessReviewScheduleDefinitionById(argument: GetScopeAccessReviewScheduleDefinitionByIdPlainArgs): GetScopeAccessReviewScheduleDefinitionByIdResult =
        getScopeAccessReviewScheduleDefinitionByIdResultToKotlin(getScopeAccessReviewScheduleDefinitionByIdPlain(argument.toJava()).await())

    /**
     * @see [getScopeAccessReviewScheduleDefinitionById].
     * @param scheduleDefinitionId The id of the access review schedule definition.
     * @param scope The scope of the resource.
     * @return Access Review Schedule Definition.
     */
    public suspend fun getScopeAccessReviewScheduleDefinitionById(
        scheduleDefinitionId: String,
        scope: String,
    ): GetScopeAccessReviewScheduleDefinitionByIdResult {
        val argument = GetScopeAccessReviewScheduleDefinitionByIdPlainArgs(
            scheduleDefinitionId = scheduleDefinitionId,
            scope = scope,
        )
        return getScopeAccessReviewScheduleDefinitionByIdResultToKotlin(getScopeAccessReviewScheduleDefinitionByIdPlain(argument.toJava()).await())
    }

    /**
     * @see [getScopeAccessReviewScheduleDefinitionById].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetScopeAccessReviewScheduleDefinitionByIdPlainArgs].
     * @return Access Review Schedule Definition.
     */
    public suspend fun getScopeAccessReviewScheduleDefinitionById(argument: suspend GetScopeAccessReviewScheduleDefinitionByIdPlainArgsBuilder.() -> Unit): GetScopeAccessReviewScheduleDefinitionByIdResult {
        val builder = GetScopeAccessReviewScheduleDefinitionByIdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScopeAccessReviewScheduleDefinitionByIdResultToKotlin(getScopeAccessReviewScheduleDefinitionByIdPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves a single variable, given its name and the subscription it was created at.
     * Azure REST API version: 2022-08-01-preview.
     * @param argument null
     * @return The variable.
     */
    public suspend fun getVariable(argument: GetVariablePlainArgs): GetVariableResult =
        getVariableResultToKotlin(getVariablePlain(argument.toJava()).await())

    /**
     * @see [getVariable].
     * @param variableName The name of the variable to operate on.
     * @return The variable.
     */
    public suspend fun getVariable(variableName: String): GetVariableResult {
        val argument = GetVariablePlainArgs(
            variableName = variableName,
        )
        return getVariableResultToKotlin(getVariablePlain(argument.toJava()).await())
    }

    /**
     * @see [getVariable].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetVariablePlainArgs].
     * @return The variable.
     */
    public suspend fun getVariable(argument: suspend GetVariablePlainArgsBuilder.() -> Unit): GetVariableResult {
        val builder = GetVariablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVariableResultToKotlin(getVariablePlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves a single variable, given its name and the  management group it was created at.
     * Azure REST API version: 2022-08-01-preview.
     * @param argument null
     * @return The variable.
     */
    public suspend fun getVariableAtManagementGroup(argument: GetVariableAtManagementGroupPlainArgs): GetVariableAtManagementGroupResult =
        getVariableAtManagementGroupResultToKotlin(getVariableAtManagementGroupPlain(argument.toJava()).await())

    /**
     * @see [getVariableAtManagementGroup].
     * @param managementGroupId The ID of the management group.
     * @param variableName The name of the variable to operate on.
     * @return The variable.
     */
    public suspend fun getVariableAtManagementGroup(managementGroupId: String, variableName: String): GetVariableAtManagementGroupResult {
        val argument = GetVariableAtManagementGroupPlainArgs(
            managementGroupId = managementGroupId,
            variableName = variableName,
        )
        return getVariableAtManagementGroupResultToKotlin(getVariableAtManagementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getVariableAtManagementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetVariableAtManagementGroupPlainArgs].
     * @return The variable.
     */
    public suspend fun getVariableAtManagementGroup(argument: suspend GetVariableAtManagementGroupPlainArgsBuilder.() -> Unit): GetVariableAtManagementGroupResult {
        val builder = GetVariableAtManagementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVariableAtManagementGroupResultToKotlin(getVariableAtManagementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves a single variable value; given its name, subscription it was created at and the variable it's created for.
     * Azure REST API version: 2022-08-01-preview.
     * @param argument null
     * @return The variable value.
     */
    public suspend fun getVariableValue(argument: GetVariableValuePlainArgs): GetVariableValueResult =
        getVariableValueResultToKotlin(getVariableValuePlain(argument.toJava()).await())

    /**
     * @see [getVariableValue].
     * @param variableName The name of the variable to operate on.
     * @param variableValueName The name of the variable value to operate on.
     * @return The variable value.
     */
    public suspend fun getVariableValue(variableName: String, variableValueName: String): GetVariableValueResult {
        val argument = GetVariableValuePlainArgs(
            variableName = variableName,
            variableValueName = variableValueName,
        )
        return getVariableValueResultToKotlin(getVariableValuePlain(argument.toJava()).await())
    }

    /**
     * @see [getVariableValue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetVariableValuePlainArgs].
     * @return The variable value.
     */
    public suspend fun getVariableValue(argument: suspend GetVariableValuePlainArgsBuilder.() -> Unit): GetVariableValueResult {
        val builder = GetVariableValuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVariableValueResultToKotlin(getVariableValuePlain(builtArgument.toJava()).await())
    }

    /**
     * This operation retrieves a single variable value; given its name,  management group it was created at and the variable it's created for.
     * Azure REST API version: 2022-08-01-preview.
     * @param argument null
     * @return The variable value.
     */
    public suspend fun getVariableValueAtManagementGroup(argument: GetVariableValueAtManagementGroupPlainArgs): GetVariableValueAtManagementGroupResult =
        getVariableValueAtManagementGroupResultToKotlin(getVariableValueAtManagementGroupPlain(argument.toJava()).await())

    /**
     * @see [getVariableValueAtManagementGroup].
     * @param managementGroupId The ID of the management group.
     * @param variableName The name of the variable to operate on.
     * @param variableValueName The name of the variable value to operate on.
     * @return The variable value.
     */
    public suspend fun getVariableValueAtManagementGroup(
        managementGroupId: String,
        variableName: String,
        variableValueName: String,
    ): GetVariableValueAtManagementGroupResult {
        val argument = GetVariableValueAtManagementGroupPlainArgs(
            managementGroupId = managementGroupId,
            variableName = variableName,
            variableValueName = variableValueName,
        )
        return getVariableValueAtManagementGroupResultToKotlin(getVariableValueAtManagementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getVariableValueAtManagementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;GetVariableValueAtManagementGroupPlainArgs].
     * @return The variable value.
     */
    public suspend fun getVariableValueAtManagementGroup(argument: suspend GetVariableValueAtManagementGroupPlainArgsBuilder.() -> Unit): GetVariableValueAtManagementGroupResult {
        val builder = GetVariableValueAtManagementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVariableValueAtManagementGroupResultToKotlin(getVariableValueAtManagementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation lists all the policy definition versions for all policy definitions within a subscription.
     * Azure REST API version: 2023-04-01.
     * @param argument null
     * @return List of policy definition versions.
     */
    public suspend fun listPolicyDefinitionVersionAll(): ListPolicyDefinitionVersionAllResult =
        listPolicyDefinitionVersionAllResultToKotlin(listPolicyDefinitionVersionAllPlain().await())

    /**
     * This operation lists all the policy definition versions for all policy definitions at the management group scope.
     * Azure REST API version: 2023-04-01.
     * @param argument null
     * @return List of policy definition versions.
     */
    public suspend fun listPolicyDefinitionVersionAllAtManagementGroup(argument: ListPolicyDefinitionVersionAllAtManagementGroupPlainArgs): ListPolicyDefinitionVersionAllAtManagementGroupResult =
        listPolicyDefinitionVersionAllAtManagementGroupResultToKotlin(listPolicyDefinitionVersionAllAtManagementGroupPlain(argument.toJava()).await())

    /**
     * @see [listPolicyDefinitionVersionAllAtManagementGroup].
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @return List of policy definition versions.
     */
    public suspend fun listPolicyDefinitionVersionAllAtManagementGroup(managementGroupName: String): ListPolicyDefinitionVersionAllAtManagementGroupResult {
        val argument = ListPolicyDefinitionVersionAllAtManagementGroupPlainArgs(
            managementGroupName = managementGroupName,
        )
        return listPolicyDefinitionVersionAllAtManagementGroupResultToKotlin(listPolicyDefinitionVersionAllAtManagementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [listPolicyDefinitionVersionAllAtManagementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;ListPolicyDefinitionVersionAllAtManagementGroupPlainArgs].
     * @return List of policy definition versions.
     */
    public suspend fun listPolicyDefinitionVersionAllAtManagementGroup(argument: suspend ListPolicyDefinitionVersionAllAtManagementGroupPlainArgsBuilder.() -> Unit): ListPolicyDefinitionVersionAllAtManagementGroupResult {
        val builder = ListPolicyDefinitionVersionAllAtManagementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listPolicyDefinitionVersionAllAtManagementGroupResultToKotlin(listPolicyDefinitionVersionAllAtManagementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation lists all the built-in policy definition versions for all built-in policy definitions.
     * Azure REST API version: 2023-04-01.
     * @param argument null
     * @return List of policy definition versions.
     */
    public suspend fun listPolicyDefinitionVersionAllBuiltins(): ListPolicyDefinitionVersionAllBuiltinsResult =
        listPolicyDefinitionVersionAllBuiltinsResultToKotlin(listPolicyDefinitionVersionAllBuiltinsPlain().await())

    /**
     * This operation lists all the policy set definition versions for all policy set definitions within a subscription.
     * Azure REST API version: 2023-04-01.
     * @param argument null
     * @return List of policy set definition versions.
     */
    public suspend fun listPolicySetDefinitionVersionAll(): ListPolicySetDefinitionVersionAllResult =
        listPolicySetDefinitionVersionAllResultToKotlin(listPolicySetDefinitionVersionAllPlain().await())

    /**
     * This operation lists all the policy set definition versions for all policy set definitions at the management group scope.
     * Azure REST API version: 2023-04-01.
     * @param argument null
     * @return List of policy set definition versions.
     */
    public suspend fun listPolicySetDefinitionVersionAllAtManagementGroup(argument: ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgs): ListPolicySetDefinitionVersionAllAtManagementGroupResult =
        listPolicySetDefinitionVersionAllAtManagementGroupResultToKotlin(listPolicySetDefinitionVersionAllAtManagementGroupPlain(argument.toJava()).await())

    /**
     * @see [listPolicySetDefinitionVersionAllAtManagementGroup].
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @return List of policy set definition versions.
     */
    public suspend fun listPolicySetDefinitionVersionAllAtManagementGroup(managementGroupName: String): ListPolicySetDefinitionVersionAllAtManagementGroupResult {
        val argument = ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgs(
            managementGroupName = managementGroupName,
        )
        return listPolicySetDefinitionVersionAllAtManagementGroupResultToKotlin(listPolicySetDefinitionVersionAllAtManagementGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [listPolicySetDefinitionVersionAllAtManagementGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;authorization&#46;kotlin&#46;inputs&#46;ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgs].
     * @return List of policy set definition versions.
     */
    public suspend fun listPolicySetDefinitionVersionAllAtManagementGroup(argument: suspend ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgsBuilder.() -> Unit): ListPolicySetDefinitionVersionAllAtManagementGroupResult {
        val builder = ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listPolicySetDefinitionVersionAllAtManagementGroupResultToKotlin(listPolicySetDefinitionVersionAllAtManagementGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation lists all the built-in policy set definition versions for all built-in policy set definitions.
     * Azure REST API version: 2023-04-01.
     * @param argument null
     * @return List of policy set definition versions.
     */
    public suspend fun listPolicySetDefinitionVersionAllBuiltins(): ListPolicySetDefinitionVersionAllBuiltinsResult =
        listPolicySetDefinitionVersionAllBuiltinsResultToKotlin(listPolicySetDefinitionVersionAllBuiltinsPlain().await())
}
