@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.ManagementLockOwnerResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.authorization.kotlin.outputs.ManagementLockOwnerResponse.Companion.toKotlin as managementLockOwnerResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ManagementLockAtResourceLevel].
 */
@PulumiTagMarker
public class ManagementLockAtResourceLevelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagementLockAtResourceLevelArgs = ManagementLockAtResourceLevelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagementLockAtResourceLevelArgsBuilder.() -> Unit) {
        val builder = ManagementLockAtResourceLevelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagementLockAtResourceLevel {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.ManagementLockAtResourceLevel(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagementLockAtResourceLevel(builtJavaResource)
    }
}

/**
 * The lock information.
 * Azure REST API version: 2020-05-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * ## Example Usage
 * ### Create management lock at resource level
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementLockAtResourceLevel = new AzureNative.Authorization.ManagementLockAtResourceLevel("managementLockAtResourceLevel", new()
 *     {
 *         Level = AzureNative.Authorization.LockLevel.ReadOnly,
 *         LockName = "testlock",
 *         ParentResourcePath = "parentResourcePath",
 *         ResourceGroupName = "resourcegroupname",
 *         ResourceName = "teststorageaccount",
 *         ResourceProviderNamespace = "Microsoft.Storage",
 *         ResourceType = "storageAccounts",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewManagementLockAtResourceLevel(ctx, "managementLockAtResourceLevel", &authorization.ManagementLockAtResourceLevelArgs{
 * 			Level:                     pulumi.String(authorization.LockLevelReadOnly),
 * 			LockName:                  pulumi.String("testlock"),
 * 			ParentResourcePath:        pulumi.String("parentResourcePath"),
 * 			ResourceGroupName:         pulumi.String("resourcegroupname"),
 * 			ResourceName:              pulumi.String("teststorageaccount"),
 * 			ResourceProviderNamespace: pulumi.String("Microsoft.Storage"),
 * 			ResourceType:              pulumi.String("storageAccounts"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.ManagementLockAtResourceLevel;
 * import com.pulumi.azurenative.authorization.ManagementLockAtResourceLevelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementLockAtResourceLevel = new ManagementLockAtResourceLevel("managementLockAtResourceLevel", ManagementLockAtResourceLevelArgs.builder()
 *             .level("ReadOnly")
 *             .lockName("testlock")
 *             .parentResourcePath("parentResourcePath")
 *             .resourceGroupName("resourcegroupname")
 *             .resourceName("teststorageaccount")
 *             .resourceProviderNamespace("Microsoft.Storage")
 *             .resourceType("storageAccounts")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:ManagementLockAtResourceLevel testlock /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}
 * ```
 */
public class ManagementLockAtResourceLevel internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.ManagementLockAtResourceLevel,
) : KotlinCustomResource(javaResource, ManagementLockAtResourceLevelMapper) {
    /**
     * The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
     */
    public val level: Output<String>
        get() = javaResource.level().applyValue({ args0 -> args0 })

    /**
     * The name of the lock.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Notes about the lock. Maximum of 512 characters.
     */
    public val notes: Output<String>?
        get() = javaResource.notes().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The owners of the lock.
     */
    public val owners: Output<List<ManagementLockOwnerResponse>>?
        get() = javaResource.owners().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> managementLockOwnerResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The resource type of the lock - Microsoft.Authorization/locks.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagementLockAtResourceLevelMapper : ResourceMapper<ManagementLockAtResourceLevel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.ManagementLockAtResourceLevel::class == javaResource::class

    override fun map(javaResource: Resource): ManagementLockAtResourceLevel =
        ManagementLockAtResourceLevel(
            javaResource as
                com.pulumi.azurenative.authorization.ManagementLockAtResourceLevel,
        )
}

/**
 * @see [ManagementLockAtResourceLevel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagementLockAtResourceLevel].
 */
public suspend fun managementLockAtResourceLevel(
    name: String,
    block: suspend ManagementLockAtResourceLevelResourceBuilder.() -> Unit,
): ManagementLockAtResourceLevel {
    val builder = ManagementLockAtResourceLevelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagementLockAtResourceLevel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managementLockAtResourceLevel(name: String): ManagementLockAtResourceLevel {
    val builder = ManagementLockAtResourceLevelResourceBuilder()
    builder.name(name)
    return builder.build()
}
