@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.ManagementLockOwnerResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.authorization.kotlin.outputs.ManagementLockOwnerResponse.Companion.toKotlin as managementLockOwnerResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ManagementLockAtSubscriptionLevel].
 */
@PulumiTagMarker
public class ManagementLockAtSubscriptionLevelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagementLockAtSubscriptionLevelArgs = ManagementLockAtSubscriptionLevelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagementLockAtSubscriptionLevelArgsBuilder.() -> Unit) {
        val builder = ManagementLockAtSubscriptionLevelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagementLockAtSubscriptionLevel {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.ManagementLockAtSubscriptionLevel(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagementLockAtSubscriptionLevel(builtJavaResource)
    }
}

/**
 * The lock information.
 * Azure REST API version: 2020-05-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * ## Example Usage
 * ### Create management lock at subscription level
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementLockAtSubscriptionLevel = new AzureNative.Authorization.ManagementLockAtSubscriptionLevel("managementLockAtSubscriptionLevel", new()
 *     {
 *         Level = AzureNative.Authorization.LockLevel.ReadOnly,
 *         LockName = "testlock",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewManagementLockAtSubscriptionLevel(ctx, "managementLockAtSubscriptionLevel", &authorization.ManagementLockAtSubscriptionLevelArgs{
 * 			Level:    pulumi.String(authorization.LockLevelReadOnly),
 * 			LockName: pulumi.String("testlock"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.ManagementLockAtSubscriptionLevel;
 * import com.pulumi.azurenative.authorization.ManagementLockAtSubscriptionLevelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementLockAtSubscriptionLevel = new ManagementLockAtSubscriptionLevel("managementLockAtSubscriptionLevel", ManagementLockAtSubscriptionLevelArgs.builder()
 *             .level("ReadOnly")
 *             .lockName("testlock")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:ManagementLockAtSubscriptionLevel testlock /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}
 * ```
 */
public class ManagementLockAtSubscriptionLevel internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.ManagementLockAtSubscriptionLevel,
) : KotlinCustomResource(javaResource, ManagementLockAtSubscriptionLevelMapper) {
    /**
     * The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
     */
    public val level: Output<String>
        get() = javaResource.level().applyValue({ args0 -> args0 })

    /**
     * The name of the lock.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Notes about the lock. Maximum of 512 characters.
     */
    public val notes: Output<String>?
        get() = javaResource.notes().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The owners of the lock.
     */
    public val owners: Output<List<ManagementLockOwnerResponse>>?
        get() = javaResource.owners().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> managementLockOwnerResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The resource type of the lock - Microsoft.Authorization/locks.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagementLockAtSubscriptionLevelMapper :
    ResourceMapper<ManagementLockAtSubscriptionLevel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.ManagementLockAtSubscriptionLevel::class == javaResource::class

    override fun map(javaResource: Resource): ManagementLockAtSubscriptionLevel =
        ManagementLockAtSubscriptionLevel(
            javaResource as
                com.pulumi.azurenative.authorization.ManagementLockAtSubscriptionLevel,
        )
}

/**
 * @see [ManagementLockAtSubscriptionLevel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagementLockAtSubscriptionLevel].
 */
public suspend fun managementLockAtSubscriptionLevel(
    name: String,
    block: suspend ManagementLockAtSubscriptionLevelResourceBuilder.() -> Unit,
): ManagementLockAtSubscriptionLevel {
    val builder = ManagementLockAtSubscriptionLevelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagementLockAtSubscriptionLevel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managementLockAtSubscriptionLevel(name: String): ManagementLockAtSubscriptionLevel {
    val builder = ManagementLockAtSubscriptionLevelResourceBuilder()
    builder.name(name)
    return builder.build()
}
